/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class EdgeDetect
extends RGBAllFilter {
    private static final double SCALE = 1.8;

    public EdgeDetect(ImageProducer producer) {
        super(producer);
    }

    public synchronized void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        for (int col = 0; col < width; ++col) {
            newPixels[0][col] = -16777216;
            newPixels[height - 1][col] = -16777216;
        }
        for (int row = 1; row < height - 1; ++row) {
            newPixels[row][0] = -16777216;
            newPixels[row][width - 1] = -16777216;
            for (int col = 1; col < width - 1; ++col) {
                long sum1 = ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col - 1]) + 2 * (ImageFilterPlus.rgbModel.getRed(rgbPixels[row][col + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row][col - 1])) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col - 1]);
                long sum2 = ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col]) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col + 1]) - (ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col]) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col + 1]));
                double sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int r = Math.min((int)sum, 255);
                sum1 = ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col - 1]) + 2 * (ImageFilterPlus.rgbModel.getGreen(rgbPixels[row][col + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row][col - 1])) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col - 1]);
                sum2 = ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col]) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col + 1]) - (ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col]) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col + 1]));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int g = Math.min((int)sum, 255);
                sum1 = ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col - 1]) + 2 * (ImageFilterPlus.rgbModel.getBlue(rgbPixels[row][col + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row][col - 1])) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col - 1]);
                sum2 = ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col]) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col + 1]) - (ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col - 1]) + 2 * ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col]) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col + 1]));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int b = Math.min((int)sum, 255);
                newPixels[row][col] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            EdgeDetect.usage();
        }
        EdgeDetect filter = new EdgeDetect(null);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: EdgeDetect");
        System.exit(1);
    }
}

