/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;

public class EnhancedCropImageFilter
extends CropImageFilter {
    protected boolean finished;
    protected boolean tdlr;
    protected boolean singleFrame;
    protected int cX;
    protected int cY;
    protected int cW;
    protected int cH;

    public EnhancedCropImageFilter(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.cX = x;
        this.cY = y;
        this.cW = w;
        this.cH = h;
    }

    public void setHints(int hints) {
        super.setHints(hints);
        if (JimiUtil.flagSet(hints, 2) && JimiUtil.flagSet(hints, 8) && JimiUtil.flagSet(hints, 4)) {
            this.tdlr = true;
            this.singleFrame = JimiUtil.flagSet(hints, 16);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel cm, byte[] pixels, int offset, int scansize) {
        if (!this.finished) {
            super.setPixels(x, y, w, h, cm, pixels, offset, scansize);
            if (y >= this.cY + this.cH) {
                this.finished = true;
                this.consumer.imageComplete(this.singleFrame ? 3 : 2);
            }
        }
    }

    public void imageComplete(int status) {
        if (!this.finished) {
            super.imageComplete(status);
        }
    }
}

