/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class Flip
extends ImageFilterPlus {
    public static final int FLIP_NULL = 0;
    public static final int FLIP_LR = 1;
    public static final int FLIP_TB = 2;
    public static final int FLIP_XY = 3;
    public static final int FLIP_CW = 4;
    public static final int FLIP_CCW = 5;
    public static final int FLIP_R180 = 6;
    private int flipType;
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;

    public Flip(ImageProducer producer, int flipType) {
        super(producer, true);
        this.flipType = flipType;
    }

    public void setHints(int hints) {
        super.setHints(hints);
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        switch (this.flipType) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                this.newWidth = width;
                this.newHeight = height;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.newWidth = height;
                this.newHeight = width;
            }
        }
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        switch (this.flipType) {
            case 0: {
                break;
            }
            case 1: {
                newX = this.width - (x + w);
                break;
            }
            case 2: {
                newY = this.height - (y + h);
                break;
            }
            case 3: {
                newW = h;
                newH = w;
                newX = y;
                newY = x;
                break;
            }
            case 4: {
                newW = h;
                newH = w;
                newX = this.height - (y + h);
                newY = x;
                break;
            }
            case 5: {
                newW = h;
                newH = w;
                newX = y;
                newY = this.width - (x + w);
                break;
            }
            case 6: {
                newX = this.width - (x + w);
                newY = this.height - (y + h);
            }
        }
        byte[] newPixels = new byte[newW * newH];
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                int index = row * scansize + off + col;
                int newRow = row;
                int newCol = col;
                switch (this.flipType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        newCol = w - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = col;
                        newCol = h - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = pixels[index];
            }
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int newX = x;
        int newY = y;
        int newW = w;
        int newH = h;
        switch (this.flipType) {
            case 0: {
                break;
            }
            case 1: {
                newX = this.width - (x + w);
                break;
            }
            case 2: {
                newY = this.height - (y + h);
                break;
            }
            case 3: {
                newW = h;
                newH = w;
                newX = y;
                newY = x;
                break;
            }
            case 4: {
                newW = h;
                newH = w;
                newX = this.height - (y + h);
                newY = x;
                break;
            }
            case 5: {
                newW = h;
                newH = w;
                newX = y;
                newY = this.width - (x + w);
                break;
            }
            case 6: {
                newX = this.width - (x + w);
                newY = this.height - (y + h);
            }
        }
        int[] newPixels = new int[newW * newH];
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                int index = row * scansize + off + col;
                int newRow = row;
                int newCol = col;
                switch (this.flipType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        newCol = w - col - 1;
                        break;
                    }
                    case 2: {
                        newRow = h - row - 1;
                        break;
                    }
                    case 3: {
                        newRow = col;
                        newCol = row;
                        break;
                    }
                    case 4: {
                        newRow = col;
                        newCol = h - row - 1;
                        break;
                    }
                    case 5: {
                        newRow = w - col - 1;
                        newCol = row;
                        break;
                    }
                    case 6: {
                        newRow = h - row - 1;
                        newCol = w - col - 1;
                    }
                }
                int newIndex = newRow * newW + newCol;
                newPixels[newIndex] = pixels[index];
            }
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Flip.usage();
        }
        int flipType = 0;
        if (args[0].equalsIgnoreCase("-lr")) {
            flipType = 1;
        } else if (args[0].equalsIgnoreCase("-tb")) {
            flipType = 2;
        } else if (args[0].equalsIgnoreCase("-xy")) {
            flipType = 3;
        } else if (args[0].equalsIgnoreCase("-cw")) {
            flipType = 4;
        } else if (args[0].equalsIgnoreCase("-ccw")) {
            flipType = 5;
        } else if (args[0].equalsIgnoreCase("-r180")) {
            flipType = 6;
        } else {
            Flip.usage();
        }
        Flip filter = new Flip(null, flipType);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Flip -lr|-tb|-xy|-cw|-ccw|-r180");
        System.exit(1);
    }
}

