/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;

public class Margin
extends ImageFilterPlus {
    private Color color;
    private int size;
    private int width;
    private int height;
    private int newWidth;
    private boolean started = false;

    public Margin(ImageProducer producer, Color color, int size) {
        super(producer, true);
        this.color = color;
        this.size = size;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.newWidth = width + this.size * 2;
        this.consumer.setDimensions(this.newWidth, height + this.size * 2);
        this.started = false;
    }

    public void resendTopDownLeftRight(ImageProducer prod) {
        this.started = false;
        super.resendTopDownLeftRight(prod);
    }

    private void start() {
        DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.started = true;
        int rgb = this.color.getRGB();
        int[] fullRow = new int[this.newWidth];
        for (int col = 0; col < this.newWidth; ++col) {
            fullRow[col] = rgb;
        }
        for (int row = 0; row < this.size; ++row) {
            this.consumer.setPixels(0, row, this.newWidth, 1, (ColorModel)cm, fullRow, 0, this.newWidth);
            this.consumer.setPixels(0, this.size + this.height + row, this.newWidth, 1, (ColorModel)cm, fullRow, 0, this.newWidth);
        }
        int[] sideRow = new int[this.size];
        for (int col = 0; col < this.size; ++col) {
            sideRow[col] = rgb;
        }
        for (int row = 0; row < this.height; ++row) {
            this.consumer.setPixels(0, this.size + row, this.size, 1, (ColorModel)cm, sideRow, 0, this.size);
            this.consumer.setPixels(this.size + this.width, this.size + row, this.size, 1, (ColorModel)cm, sideRow, 0, this.size);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(x + this.size, y + this.size, w, h, model, pixels, off, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(x + this.size, y + this.size, w, h, model, pixels, off, scansize);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Margin.usage();
        }
        Margin filter = new Margin(null, Color.black, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Margin <size>");
        System.exit(1);
    }
}

