/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Oil
extends RGBAllFilter {
    private int n;

    public Oil(ImageProducer producer, int n) {
        super(producer);
        this.n = n;
    }

    public Oil(ImageProducer producer) {
        this(producer, 3);
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        int[] rHist = new int[256];
        int[] gHist = new int[256];
        int[] bHist = new int[256];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                for (int i = 0; i < 256; ++i) {
                    bHist[i] = 0;
                    gHist[i] = 0;
                    rHist[i] = 0;
                }
                for (int drow = row - this.n; drow <= row + this.n; ++drow) {
                    if (drow < 0 || drow >= height) continue;
                    for (int dcol = col - this.n; dcol <= col + this.n; ++dcol) {
                        if (dcol < 0 || dcol >= width) continue;
                        int rgb = rgbPixels[drow][dcol];
                        int n = rgb >> 16 & 0xFF;
                        rHist[n] = rHist[n] + 1;
                        int n2 = rgb >> 8 & 0xFF;
                        gHist[n2] = gHist[n2] + 1;
                        int n3 = rgb & 0xFF;
                        bHist[n3] = bHist[n3] + 1;
                    }
                }
                int r = 0;
                int g = 0;
                int b = 0;
                for (int i = 1; i < 256; ++i) {
                    if (rHist[i] > rHist[r]) {
                        r = i;
                    }
                    if (gHist[i] > gHist[g]) {
                        g = i;
                    }
                    if (bHist[i] <= bHist[b]) continue;
                    b = i;
                }
                newPixels[row][col] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        int argn;
        int n = -1;
        int argc = args.length;
        for (argn = 0; argn < argc && args[argn].charAt(0) == '-'; ++argn) {
            if (args[argn].equals("-n") && argn + 1 < argc) {
                n = Integer.parseInt(args[++argn]);
                continue;
            }
            Oil.usage();
        }
        if (argn != argc) {
            Oil.usage();
        }
        Oil filter = n == -1 ? new Oil(null) : new Oil(null, n);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Oil [-n N]");
        System.exit(1);
    }
}

