/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public abstract class RGBAllFilter
extends ImageFilterPlus {
    private int width = -1;
    private int height = -1;
    private int[][] rgbPixels = null;

    public RGBAllFilter(ImageProducer producer) {
        super(producer);
    }

    public abstract void filterRGBAll(int var1, int var2, int[][] var3);

    public synchronized void setPixels(int newWidth, int newHeight, int[][] newPixels) {
        this.consumer.setDimensions(newWidth, newHeight);
        for (int row = 0; row < newHeight; ++row) {
            this.consumer.setPixels(0, row, newWidth, 1, ImageFilterPlus.rgbModel, newPixels[row], 0, newWidth);
        }
    }

    public synchronized void setColorModel(ColorModel model) {
        this.consumer.setColorModel(ImageFilterPlus.rgbModel);
    }

    public synchronized void setDimensions(int width, int height) {
        if (width == this.width && height == this.height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        for (int row = 0; row < h; ++row) {
            int rowOffsetIn = row * scansize + off;
            for (int col = 0; col < w; ++col) {
                this.rgbPixels[y + row][x + col] = model.getRGB(pixels[rowOffsetIn + col] & 0xFF);
            }
        }
    }

    public synchronized void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        for (int row = 0; row < h; ++row) {
            int rowOffsetIn = row * scansize + off;
            if (model == ImageFilterPlus.rgbModel) {
                System.arraycopy(pixels, rowOffsetIn, this.rgbPixels[y + row], x, w);
                continue;
            }
            for (int col = 0; col < w; ++col) {
                this.rgbPixels[y + row][x + col] = model.getRGB(pixels[rowOffsetIn + col]);
            }
        }
    }

    public synchronized void imageComplete(int status) {
        if (status == 1 || status == 4) {
            super.imageComplete(status);
            return;
        }
        this.filterRGBAll(this.width, this.height, this.rgbPixels);
        super.imageComplete(status);
    }
}

