/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class Rotate
extends ImageFilter {
    private double angle;
    private double cos;
    private double sin;
    private Rectangle rotatedSpace;
    private Rectangle originalSpace;
    private ColorModel defaultRGBModel;
    private int[] inPixels;
    private int[] outPixels;

    public Rotate(double angle) {
        this.angle = angle * (Math.PI / 180);
        this.cos = Math.cos(this.angle);
        this.sin = Math.sin(this.angle);
        this.defaultRGBModel = ColorModel.getRGBdefault();
    }

    private void transform(int x, int y, double[] out) {
        out[0] = (double)x * this.cos + (double)y * this.sin;
        out[1] = (double)y * this.cos - (double)x * this.sin;
    }

    private void transformBack(int x, int y, double[] out) {
        out[0] = (double)x * this.cos - (double)y * this.sin;
        out[1] = (double)y * this.cos + (double)x * this.sin;
    }

    public void transformSpace(Rectangle rect) {
        double[] out = new double[2];
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double maxy = Double.MIN_VALUE;
        int w = rect.width;
        int h = rect.height;
        int x = rect.x;
        int y = rect.y;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    this.transform(x + 0, y + 0, out);
                    break;
                }
                case 1: {
                    this.transform(x + w, y + 0, out);
                    break;
                }
                case 2: {
                    this.transform(x + 0, y + h, out);
                    break;
                }
                case 3: {
                    this.transform(x + w, y + h, out);
                }
            }
            minx = Math.min(minx, out[0]);
            miny = Math.min(miny, out[1]);
            maxx = Math.max(maxx, out[0]);
            maxy = Math.max(maxy, out[1]);
        }
        rect.x = (int)Math.floor(minx);
        rect.y = (int)Math.floor(miny);
        rect.width = (int)Math.ceil(maxx) - rect.x;
        rect.height = (int)Math.ceil(maxy) - rect.y;
    }

    public void setDimensions(int width, int height) {
        this.originalSpace = new Rectangle(0, 0, width, height);
        this.rotatedSpace = new Rectangle(0, 0, width, height);
        this.transformSpace(this.rotatedSpace);
        this.inPixels = new int[this.originalSpace.width * this.originalSpace.height];
        this.consumer.setDimensions(this.rotatedSpace.width, this.rotatedSpace.height);
    }

    public void setColorModel(ColorModel model) {
        this.consumer.setColorModel(this.defaultRGBModel);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int index = y * this.originalSpace.width + x;
        int srcindex = off;
        int srcinc = scansize - w;
        int indexinc = this.originalSpace.width - w;
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                this.inPixels[index++] = model.getRGB(pixels[srcindex++] & 0xFF);
            }
            srcindex += srcinc;
            index += indexinc;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int index = y * this.originalSpace.width + x;
        int srcindex = off;
        int srcinc = scansize - w;
        int indexinc = this.originalSpace.width - w;
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                this.inPixels[index++] = model.getRGB(pixels[srcindex++]);
            }
            srcindex += srcinc;
            index += indexinc;
        }
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        double[] point = new double[2];
        int srcwidth = this.originalSpace.width;
        int srcheight = this.originalSpace.height;
        int outwidth = this.rotatedSpace.width;
        int outheight = this.rotatedSpace.height;
        this.outPixels = new int[outwidth * outheight];
        int outx = this.rotatedSpace.x;
        int outy = this.rotatedSpace.y;
        double[] end = new double[2];
        int index = 0;
        for (int y = 0; y < outheight; ++y) {
            for (int x = 0; x < outwidth; ++x) {
                this.transformBack(outx + x, outy + y, point);
                int srcx = (int)Math.round(point[0]);
                int srcy = (int)Math.round(point[1]);
                this.outPixels[index++] = srcx < 0 || srcx >= srcwidth || srcy < 0 || srcy >= srcheight ? 0 : this.inPixels[srcy * srcwidth + srcx];
            }
        }
        this.consumer.setPixels(0, 0, outwidth, outheight, this.defaultRGBModel, this.outPixels, 0, outwidth);
        this.consumer.imageComplete(status);
    }
}

