/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class ScaleCopy
extends ImageFilterPlus {
    private double xScale;
    private double yScale;
    private int newWidth;
    private int newHeight;

    public ScaleCopy(ImageProducer producer, double scale) {
        this(producer, scale, scale);
    }

    public ScaleCopy(ImageProducer producer, double xScale, double yScale) {
        super(producer);
        this.xScale = xScale;
        this.yScale = yScale;
    }

    public void setDimensions(int width, int height) {
        this.newWidth = (int)((double)width * this.xScale);
        this.newHeight = (int)((double)height * this.yScale);
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int newH;
        int newX = Math.min((int)((double)x * this.xScale), this.newWidth - 1);
        int newY = Math.min((int)((double)y * this.yScale), this.newHeight - 1);
        int newW = Math.max((int)((double)w * this.xScale), 1);
        if (newX + newW > this.newWidth) {
            newW = this.newWidth - newX;
        }
        if (newY + (newH = Math.max((int)((double)h * this.yScale), 1)) > this.newHeight) {
            newH = this.newHeight - newY;
        }
        byte[] newPixels = new byte[newW * newH];
        for (int newRow = 0; newRow < newH; ++newRow) {
            int row = (int)((double)newRow / this.yScale);
            if (row >= h) continue;
            for (int newCol = 0; newCol < newW; ++newCol) {
                int col = (int)((double)newCol / this.xScale);
                if (col >= w) continue;
                newPixels[newRow * newW + newCol] = pixels[row * scansize + off + col];
            }
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int newH;
        int newX = Math.min((int)((double)x * this.xScale), this.newWidth - 1);
        int newY = Math.min((int)((double)y * this.yScale), this.newHeight - 1);
        int newW = Math.max((int)((double)w * this.xScale), 1);
        if (newX + newW > this.newWidth) {
            newW = this.newWidth - newX;
        }
        if (newY + (newH = Math.max((int)((double)h * this.yScale), 1)) > this.newHeight) {
            newH = this.newHeight - newY;
        }
        int[] newPixels = new int[newW * newH];
        for (int newRow = 0; newRow < newH; ++newRow) {
            int row = (int)((double)newRow / this.yScale);
            if (row >= h) continue;
            for (int newCol = 0; newCol < newW; ++newCol) {
                int col = (int)((double)newCol / this.xScale);
                if (col >= w) continue;
                newPixels[newRow * newW + newCol] = pixels[row * scansize + off + col];
            }
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public static void main(String[] args) {
        ScaleCopy filter = null;
        if (args.length == 1) {
            filter = new ScaleCopy(null, Double.valueOf(args[0]));
        } else if (args.length == 2) {
            filter = new ScaleCopy(null, Double.valueOf(args[0]), Double.valueOf(args[1]));
        } else {
            ScaleCopy.usage();
        }
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: ScaleCopy scale");
        System.err.println("or:    ScaleCopy xScale yScale");
        System.exit(1);
    }
}

