/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Shear
extends RGBAllFilter {
    private double angle;

    public Shear(ImageProducer producer, double angle) {
        super(producer);
        this.angle = angle * Math.PI / 180.0;
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        if (this.angle == 0.0) {
            this.setPixels(width, height, rgbPixels);
            return;
        }
        double shearfac = Math.tan(this.angle);
        if (shearfac < 0.0) {
            shearfac = -shearfac;
        }
        int newWidth = (int)((double)height * shearfac + (double)width + 0.999999);
        int[][] newPixels = new int[height][newWidth];
        for (int row = 0; row < height; ++row) {
            double new0 = this.angle > 0.0 ? (double)row * shearfac : (double)(height - row) * shearfac;
            int intnew0 = (int)new0;
            double fracnew0 = new0 - (double)intnew0;
            double omfracnew0 = 1.0 - fracnew0;
            for (int col = 0; col < newWidth; ++col) {
                newPixels[row][col] = 0;
            }
            int preva = 0;
            int prevr = rgbPixels[row][0] >> 16 & 0xFF;
            int prevg = rgbPixels[row][0] >> 8 & 0xFF;
            int prevb = rgbPixels[row][0] & 0xFF;
            for (int col = 0; col < width; ++col) {
                int rgb = rgbPixels[row][col];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                newPixels[row][intnew0 + col] = (int)(fracnew0 * (double)preva + omfracnew0 * (double)a) << 24 | (int)(fracnew0 * (double)prevr + omfracnew0 * (double)r) << 16 | (int)(fracnew0 * (double)prevg + omfracnew0 * (double)g) << 8 | (int)(fracnew0 * (double)prevb + omfracnew0 * (double)b);
                preva = a;
                prevr = r;
                prevg = g;
                prevb = b;
            }
            newPixels[row][intnew0 + width] = (int)(fracnew0 * (double)preva) << 24 | prevr << 16 | prevg << 8 | prevb;
        }
        this.setPixels(newWidth, height, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Shear.usage();
        }
        Shear filter = new Shear(null, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Shear <angle>");
        System.exit(1);
    }
}

