/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.Enlarge;
import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Shrink
extends RGBAllFilter {
    private int divisor;

    public Shrink(ImageProducer producer, int divisor) {
        super(producer);
        this.divisor = divisor;
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int divisor2 = this.divisor * this.divisor;
        int newWidth = Math.max(width / this.divisor, 1);
        int newHeight = Math.max(height / this.divisor, 1);
        int[][] newPixels = new int[newHeight][newWidth];
        for (int newRow = 0; newRow < newHeight; ++newRow) {
            for (int newCol = 0; newCol < newWidth; ++newCol) {
                int a = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                for (int i = 0; i < this.divisor; ++i) {
                    int row = newRow * this.divisor + i;
                    if (row >= height) continue;
                    for (int j = 0; j < this.divisor; ++j) {
                        int col = newCol * this.divisor + j;
                        if (col >= width) continue;
                        int rgb = rgbPixels[row][col];
                        a += rgb >> 24 & 0xFF;
                        r += rgb >> 16 & 0xFF;
                        g += rgb >> 8 & 0xFF;
                        b += rgb & 0xFF;
                    }
                }
                newPixels[newRow][newCol] = (a /= divisor2) << 24 | (r /= divisor2) << 16 | (g /= divisor2) << 8 | (b /= divisor2);
            }
        }
        this.setPixels(newWidth, newHeight, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Shrink.usage();
        }
        Enlarge filter = new Enlarge(null, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Shrink <divisor>");
        System.exit(1);
    }
}

