/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Smooth
extends RGBAllFilter {
    private int n;

    public Smooth(ImageProducer producer, int n) {
        super(producer);
        this.n = n;
    }

    public Smooth(ImageProducer producer) {
        this(producer, 1);
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int a = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int c = 0;
                for (int subrow = row - this.n; subrow <= row + this.n; ++subrow) {
                    if (subrow < 0 || subrow >= height) continue;
                    for (int subcol = col - this.n; subcol <= col + this.n; ++subcol) {
                        if (subcol < 0 || subcol >= width) continue;
                        int rgb = rgbPixels[subrow][subcol];
                        a += rgb >> 24 & 0xFF;
                        r += rgb >> 16 & 0xFF;
                        g += rgb >> 8 & 0xFF;
                        b += rgb & 0xFF;
                        ++c;
                    }
                }
                newPixels[row][col] = (a /= c) << 24 | (r /= c) << 16 | (g /= c) << 8 | (b /= c);
            }
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        int argn;
        int n = -1;
        int argc = args.length;
        for (argn = 0; argn < argc && args[argn].charAt(0) == '-'; ++argn) {
            if (args[argn].equals("-n") && argn + 1 < argc) {
                n = Integer.parseInt(args[++argn]);
                continue;
            }
            Smooth.usage();
        }
        if (argn != argc) {
            Smooth.usage();
        }
        Smooth filter = n == -1 ? new Smooth(null) : new Smooth(null, n);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Smooth [-n N]");
        System.exit(1);
    }
}

