/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.options;

import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.OptionException;

public class IntOption
extends FormatOption {
    protected int intValue;
    protected boolean bounded = false;
    protected int min;
    protected int max;
    static /* synthetic */ Class class$java$lang$Integer;

    public IntOption(String name, String description, int defaultValue) {
        super(name, description, class$java$lang$Integer == null ? (class$java$lang$Integer = IntOption.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(defaultValue));
        this.intValue = defaultValue;
    }

    public IntOption(String name, String description, int defaultValue, int minValue, int maxValue) {
        this(name, description, defaultValue);
        this.bounded = true;
        this.min = minValue;
        this.max = maxValue;
    }

    public void parseValue(String value) throws OptionException {
        try {
            this.setIntValue(Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new OptionException("Invalid option: " + value);
        }
    }

    public void setValue(Object value) throws OptionException {
        if (!(value instanceof Number)) {
            throw new OptionException("Invalid option: " + value);
        }
        this.setIntValue(((Number)value).intValue());
    }

    public Object getValue() {
        return new Integer(this.intValue);
    }

    public void setIntValue(int value) throws OptionException {
        if (this.bounded && (value < this.min || value > this.max)) {
            throw new OptionException("Value out of bounds.");
        }
        this.intValue = value;
    }

    public int getIntValue() {
        return this.intValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

