/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;

class ImportConsumer
implements ImageConsumer {
    protected ImageProducer source;
    protected JimiImageFactory imageFactory;
    protected IntRasterImage intImage;
    protected ByteRasterImage byteImage;
    protected JimiRasterImage importedImage;
    protected int width = -1;
    protected int height = -1;
    protected ColorModel colorModel;
    protected boolean forceRGB;
    protected boolean finished;
    protected boolean aborted;

    public ImportConsumer(JimiImageFactory factory, ImageProducer producer, boolean forceRGB) {
        this.imageFactory = factory;
        this.source = producer;
        this.forceRGB = forceRGB;
    }

    public void startImporting() {
        this.source.startProduction(this);
    }

    public synchronized void waitFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void setFinished() {
        this.finished = true;
        if (this.importedImage != null) {
            ((MutableJimiRasterImage)this.importedImage).setFinished();
        }
        this.notifyAll();
    }

    protected synchronized void abort() {
        this.aborted = true;
        this.setFinished();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public JimiRasterImage getImage() {
        return this.importedImage;
    }

    protected void checkProxy(byte[] bytes) throws JimiException {
        if (this.importedImage == null) {
            if (this.forceRGB) {
                this.createIntImage();
            } else {
                this.createByteImage();
            }
        }
    }

    protected void checkProxy(int[] ints) throws JimiException {
        if (this.importedImage == null) {
            if (this.forceRGB) {
                this.createIntImage();
            } else {
                this.createIntImage();
            }
        }
    }

    protected void createIntImage() throws JimiException {
        this.intImage = this.imageFactory.createIntRasterImage(this.width, this.height, this.colorModel);
        this.importedImage = this.intImage;
    }

    protected void createByteImage() throws JimiException {
        if (this.colorModel instanceof IndexColorModel && ((IndexColorModel)this.colorModel).getMapSize() <= 2) {
            this.byteImage = this.imageFactory.createBitRasterImage(this.width, this.height, this.colorModel);
            this.importedImage = this.byteImage;
        } else {
            this.byteImage = this.imageFactory.createByteRasterImage(this.width, this.height, this.colorModel);
            this.importedImage = this.byteImage;
        }
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel cm) {
        this.colorModel = this.forceRGB ? new DirectColorModel(24, 0xFF0000, 65280, 255) : cm;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setHints(int hintflags) {
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.finished) {
            return;
        }
        try {
            this.checkProxy(pixels);
        }
        catch (JimiException e) {
            this.abort();
            return;
        }
        if (this.forceRGB) {
            this.setPixelsRGB(x, y, w, h, model, pixels, off, scansize);
        } else if (model == this.colorModel) {
            try {
                this.byteImage.setRectangle(x, y, w, h, pixels, off, scansize);
            }
            catch (ImageAccessException e) {
                this.abort();
            }
        } else {
            this.abort();
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (this.finished) {
            return;
        }
        try {
            this.checkProxy(pixels);
        }
        catch (JimiException e) {
            this.abort();
            return;
        }
        if (this.forceRGB) {
            this.setPixelsRGB(x, y, w, h, model, pixels, off, scansize);
        } else if (model == this.colorModel) {
            try {
                this.intImage.setRectangle(x, y, w, h, pixels, off, scansize);
            }
            catch (ImageAccessException e) {
                this.abort();
            }
        } else {
            this.abort();
        }
    }

    public void imageComplete(int status) {
        this.source.removeConsumer(this);
        if (!this.finished) {
            if (!this.finished && status != 1 && status != 4) {
                this.setFinished();
            } else {
                this.abort();
            }
        }
    }

    protected void setPixelsRGB(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int[] rowBuf = new int[pixels.length];
        for (int row = 0; row < h; ++row) {
            for (int column = 0; column < w; ++column) {
                rowBuf[column] = model.getRGB(pixels[off + row * scansize + column]);
            }
            try {
                this.intImage.setRectangle(x, y + row, w, 1, rowBuf, 0, w);
                continue;
            }
            catch (ImageAccessException e) {
                this.abort();
            }
        }
    }

    protected void setPixelsRGB(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int[] rowBuf = new int[pixels.length];
        for (int row = 0; row < h; ++row) {
            for (int column = 0; column < w; ++column) {
                rowBuf[column] = model.getRGB(pixels[off + row * scansize + column]);
            }
            try {
                this.intImage.setRectangle(x, y + row, w, 1, rowBuf, 0, w);
                continue;
            }
            catch (ImageAccessException e) {
                this.abort();
            }
        }
    }
}

