/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.LongRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class JimiRasterImageCategorizer {
    public static boolean isPaletteImage(JimiImage image) {
        image = JimiUtil.asJimiRasterImage(image);
        return ((JimiRasterImage)image).getColorModel() instanceof IndexColorModel;
    }

    public static boolean isBytePaletteImage(JimiImage image) {
        return JimiRasterImageCategorizer.isPaletteImage(image = JimiUtil.asJimiRasterImage(image)) && image instanceof ByteRasterImage;
    }

    public static boolean isMonoColorImage(JimiImage image) {
        return JimiRasterImageCategorizer.isBytePaletteImage(image) && ((IndexColorModel)((JimiRasterImage)image).getColorModel()).getMapSize() == 2;
    }

    public static boolean isGrayscaleImage(JimiImage image) {
        JimiRasterImage rimage = JimiUtil.asJimiRasterImage(image);
        if (rimage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel cm = (DirectColorModel)rimage.getColorModel();
            return cm.getRedMask() == cm.getGreenMask() && cm.getRedMask() == cm.getBlueMask();
        }
        return false;
    }

    public static boolean isLongRasterImage(JimiImage image) {
        image = JimiUtil.asJimiRasterImage(image);
        return image instanceof LongRasterImage;
    }
}

