/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.CroppedRasterImageProducer;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public abstract class JimiRasterImageSupport
implements MutableJimiRasterImage,
ImageProducer {
    private static final int HINTS_UNSET = -1;
    protected boolean error = false;
    protected boolean abort = false;
    protected boolean productionStarted = false;
    protected boolean modified = false;
    protected boolean productionAllowed = false;
    protected boolean finished = false;
    protected boolean newFrameData = false;
    protected ColorModel colorModel;
    protected Hashtable properties = new Hashtable();
    private boolean hasConsumer = false;
    private int width;
    private int height;
    private int state;
    private int DEFAULT_HINTS;
    private int hints = this.DEFAULT_HINTS = 30;
    private MulticastImageConsumer directConsumer = new MulticastImageConsumer();
    private MulticastImageConsumer waitingConsumer = new MulticastImageConsumer();
    private JimiDecodingController decodingController;
    private JimiImageFactory imageFactory = new MemoryJimiImageFactory();
    private FormatOptionSet options = new BasicFormatOptionSet(new FormatOption[0]);
    protected ColorModel sourceColorModel = null;
    protected boolean forceRGB = false;
    protected int[] rowBuf;
    protected boolean waitForOptions;

    protected JimiRasterImageSupport(int w, int h, ColorModel cm) {
        this.width = w;
        this.height = h;
        this.setColorModel(cm);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setColorModel(ColorModel cm) {
        if (!this.forceRGB) {
            this.colorModel = this.getAppropriateColorModel(cm);
            this.forceRGB |= cm != this.colorModel;
        }
        this.sourceColorModel = cm;
    }

    public void setImageConsumerHints(int hints) {
        this.hints = hints |= 0x10;
    }

    public boolean isError() {
        return this.error;
    }

    public synchronized void setError() {
        this.error = true;
        this.directConsumer.imageComplete(1);
        this.waitingConsumer.imageComplete(1);
        this.notifyAll();
    }

    public void setFactory(JimiImageFactory factory) {
        this.imageFactory = factory;
    }

    public JimiImageFactory getFactory() {
        return this.imageFactory;
    }

    public void setOptions(FormatOptionSet options) {
        this.options = options;
    }

    public FormatOptionSet getOptions() {
        if (this.waitForOptions) {
            this.waitFinished();
        }
        return this.options;
    }

    public synchronized void setFinished() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.newFrameData = false;
        this.directConsumer.imageComplete(3);
        this.directConsumer.removeAll();
        if (!this.waitingConsumer.isEmpty()) {
            try {
                this.sendToConsumerFully(this.waitingConsumer);
            }
            catch (ImageAccessException e) {
                this.setError();
                return;
            }
        }
        ImageConsumer[] waitingConsumers = this.waitingConsumer.getConsumers();
        this.waitingConsumer.imageComplete(3);
        this.waitingConsumer.removeAll();
        this.notifyAll();
    }

    public void waitInfoAvailable() {
    }

    public synchronized void waitFinished() {
        this.productionStarted = true;
        if (this.decodingController != null) {
            this.decodingController.requestDecoding();
        }
        while (!this.finished && !this.error) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void setDecodingController(JimiDecodingController controller) {
        this.decodingController = controller;
        if (this.hasConsumer || this.productionStarted) {
            controller.requestDecoding();
        }
    }

    public synchronized void addConsumer(ImageConsumer consumer) {
        this.hasConsumer = true;
        this.initConsumer(consumer);
        if (!this.productionStarted) {
            this.addDirectConsumer(consumer);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        } else if (this.finished) {
            this.addWaitingConsumer(consumer);
        } else {
            boolean consumerUpToDate = this.catchupConsumer(consumer);
            if (consumerUpToDate) {
                this.addDirectConsumer(consumer);
            } else {
                this.addWaitingConsumer(consumer);
            }
        }
    }

    protected void addDirectConsumer(ImageConsumer consumer) {
        consumer.setDimensions(this.getWidth(), this.getHeight());
        this.directConsumer.addConsumer(consumer);
        consumer.setHints(this.hints);
    }

    protected synchronized void addWaitingConsumer(ImageConsumer consumer) {
        consumer.setDimensions(this.getWidth(), this.getHeight());
        consumer.setHints(this.DEFAULT_HINTS);
        if (this.finished) {
            try {
                this.sendToConsumerFully(consumer);
                consumer.imageComplete(3);
            }
            catch (ImageAccessException e) {
                consumer.imageComplete(1);
            }
        } else {
            this.waitingConsumer.addConsumer(consumer);
        }
    }

    protected synchronized boolean catchupConsumer(ImageConsumer consumer) {
        return false;
    }

    public ImageProducer getImageProducer() {
        return this;
    }

    public boolean isConsumer(ImageConsumer consumer) {
        return this.directConsumer.contains(consumer) || this.waitingConsumer.contains(consumer);
    }

    public void removeConsumer(ImageConsumer consumer) {
        this.directConsumer.removeConsumer(consumer);
        this.waitingConsumer.removeConsumer(consumer);
    }

    public void startProduction(ImageConsumer consumer) {
        this.removeConsumer(consumer);
        this.addConsumer(consumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
        this.addWaitingConsumer(consumer);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public ImageProducer getCroppedImageProducer(int x, int y, int width, int height) {
        return new CroppedRasterImageProducer(this, x, y, width, height);
    }

    public synchronized void produceCroppedImage(ImageConsumer consumer, Rectangle region) {
        this.waitFinished();
        this.initConsumer(consumer);
        consumer.setDimensions(region.width, region.height);
        consumer.setHints(this.DEFAULT_HINTS);
        try {
            this.sendRegionToConsumerFully(consumer, region);
            consumer.imageComplete(3);
        }
        catch (Exception e) {
            consumer.imageComplete(1);
        }
    }

    protected MulticastImageConsumer getDirectConsumer() {
        return this.directConsumer;
    }

    protected boolean hasDirectConsumer() {
        return !this.directConsumer.isEmpty();
    }

    protected abstract void sendToConsumerFully(ImageConsumer var1) throws ImageAccessException;

    protected abstract void sendRegionToConsumerFully(ImageConsumer var1, Rectangle var2) throws ImageAccessException;

    protected void initConsumer(ImageConsumer consumer) {
        consumer.setColorModel(this.getColorModel());
        consumer.setProperties(this.properties);
    }

    protected ColorModel getAppropriateColorModel(ColorModel cm) {
        return cm;
    }

    protected void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.directConsumer.setHints(this.hints);
            this.productionStarted = true;
            if (this.decodingController != null) {
                this.decodingController.requestDecoding();
            }
        }
    }

    public void getChannelRectangle(int channel, int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            if (this.rowBuf == null) {
                this.rowBuf = new int[width];
            }
            for (int row = 0; row < height; ++row) {
                this.getRowRGB(y + row, this.rowBuf, 0);
                for (int column = 0; column < width; ++column) {
                    buffer[offset + column + row * scansize] = (byte)(this.rowBuf[column] >>> channel);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public synchronized void getChannelRow(int channel, int y, byte[] buffer, int offset) throws ImageAccessException {
        this.getChannelRectangle(channel, 0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public synchronized void getRectangleRGBChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[width];
        }
        for (int row = 0; row < height; ++row) {
            this.getRowRGB(y + row, this.rowBuf, 0);
            int srcindex = 0;
            int destindex = 0;
            for (int column = 0; column < width; ++column) {
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 16);
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 8);
                buffer[row * scansize + destindex++ + offset] = (byte)this.rowBuf[srcindex++];
            }
        }
    }

    public synchronized void getRectangleARGBChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[width];
        }
        for (int row = 0; row < height; ++row) {
            this.getRowRGB(y + row, this.rowBuf, 0);
            int srcindex = 0;
            int destindex = 0;
            for (int column = 0; column < width; ++column) {
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 24);
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 16);
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 8);
                buffer[row * scansize + destindex++ + offset] = (byte)this.rowBuf[srcindex++];
            }
        }
    }

    public synchronized void getRectangleRGBAChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[width];
        }
        for (int row = 0; row < height; ++row) {
            this.getRowRGB(y + row, this.rowBuf, 0);
            int srcindex = 0;
            int destindex = 0;
            for (int column = 0; column < width; ++column) {
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 16);
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex] >>> 8);
                buffer[row * scansize + destindex++ + offset] = (byte)this.rowBuf[srcindex];
                buffer[row * scansize + destindex++ + offset] = (byte)(this.rowBuf[srcindex++] >>> 24);
            }
        }
    }

    public void setWaitForOptions(boolean wait) {
        this.waitForOptions = wait;
    }

    public boolean mustWaitForOptions() {
        return this.waitForOptions;
    }

    public abstract /* synthetic */ int getPixelRGB(int var1, int var2) throws ImageAccessException;

    public abstract /* synthetic */ void getRectangleRGB(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws ImageAccessException;

    public abstract /* synthetic */ void getRowRGB(int var1, int[] var2, int var3) throws ImageAccessException;
}

