/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryBitRasterImage
extends JimiRasterImageSupport
implements BitRasterImage {
    protected byte[] imageData;
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowBuffer;
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    public MemoryBitRasterImage(int width, int height, ColorModel cm) {
        super(width, height, cm);
        int color0 = cm.getRGB(0);
        int color1 = cm.getRGB(1);
        byte[] alphas = new byte[]{(byte)(color0 >> 24 & 0xFF), (byte)(color1 >> 24 & 0xFF)};
        byte[] reds = new byte[]{(byte)(color0 >> 16 & 0xFF), (byte)(color1 >> 16 & 0xFF)};
        byte[] greens = new byte[]{(byte)(color0 >> 8 & 0xFF), (byte)(color1 >> 8 & 0xFF)};
        byte[] blues = new byte[]{(byte)(color0 >> 0 & 0xFF), (byte)(color1 >> 0 & 0xFF)};
        IndexColorModel icm = new IndexColorModel(8, 2, reds, greens, blues, alphas);
        this.setColorModel(icm);
        this.rowByteWidth = (width + 7) / 8;
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new byte[this.rowByteWidth * this.getHeight()];
        this.rowBuffer = new byte[this.rowByteWidth];
        this.rowUnpackedBuffer = new byte[this.rowByteWidth * 8];
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
        this.storeRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void sendRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(x, y, width, height, this.getColorModel(), pixels, offset, scansize);
    }

    public void storeRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        for (int row = 0; row < height; ++row) {
            JimiUtil.packOneBitPixels(pixels, offset + row * scansize, this.imageData, (y + row) * this.rowByteWidth, x, width);
        }
    }

    public void setRow(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, byte value) throws ImageAccessException {
        this.setModified();
        this.storePixel(x, y, value);
        this.sendPixel(x, y, value);
    }

    protected synchronized void sendPixel(int x, int y, byte value) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        this.pixelBuffer[0] = value;
        consumer.setPixels(x, y, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 0);
    }

    protected void storePixel(int x, int y, byte value) throws ImageAccessException {
        int index;
        byte pixelMask = (byte)(1 << 7 - x % 8);
        int n = index = (x >>> 3) + y * this.rowByteWidth;
        this.imageData[n] = (byte)(this.imageData[n] & ~pixelMask);
        int n2 = index;
        this.imageData[n2] = (byte)(this.imageData[n2] | pixelMask);
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        ColorModel cm = this.getColorModel();
        for (int row = 0; row < height; ++row) {
            this.getRow(y + row, this.rowUnpackedBuffer, 0);
            for (int column = 0; column < width; ++column) {
                int index = row * scansize + column;
                buffer[index] = cm.getRGB(this.rowUnpackedBuffer[column]);
            }
        }
    }

    public void getRowRGB(int y, int[] buffer, int offset) throws ImageAccessException {
        this.getRectangleRGB(0, y, this.getWidth(), 1, buffer, offset, this.getWidth());
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(x, y));
    }

    public void getRectangle(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        for (int row = 0; row < height; ++row) {
            JimiUtil.expandOneBitPixels(this.imageData, buffer, width, (y + row) * (this.rowByteWidth * 8) + x, offset + row * scansize);
        }
    }

    public void getRow(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.getRectangle(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public byte getPixel(int x, int y) throws ImageAccessException {
        return (this.imageData[x / 8 + y * this.rowByteWidth] & 7 - x % 8) == 0 ? (byte)0 : 1;
    }

    public void setRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(x, y, width, height, pixels, offset, scansize);
        this.storeRectanglePacked(x, y, width, height, pixels, offset, scansize);
    }

    public void storeRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        for (int row = 0; row < height; ++row) {
            System.arraycopy(pixels, offset + row * scansize, this.imageData, x / 8 + (y + row) * this.rowByteWidth, width / 8);
        }
    }

    protected void sendRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        offset *= 8;
        for (int row = 0; row < height; ++row) {
            JimiUtil.expandOneBitPixels(pixels, this.rowUnpackedBuffer, offset + width, row * width * 8, row * width);
        }
        consumer.setPixels(x, y, width, height, this.getColorModel(), this.rowUnpackedBuffer, 0, width);
    }

    public void setRowPacked(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectanglePacked(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void getRectanglePacked(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        for (int row = 0; row < height; ++row) {
            System.arraycopy(this.imageData, x / 8 + (y + row) * this.rowByteWidth, buffer, offset + row * scansize, width / 8);
        }
    }

    public void getRowPacked(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.getRectanglePacked(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) {
        int width = this.getWidth();
        int height = this.getHeight();
        for (int row = 0; row < height; ++row) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, width, this.rowByteWidth * 8 * row, 0);
            consumer.setPixels(0, row, width, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, 0);
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) {
        int x = region.x;
        int y = region.y;
        int width = region.width;
        int height = region.height;
        ColorModel cm = this.getColorModel();
        for (int row = 0; row < region.height; ++row) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, region.width, this.rowByteWidth * 8 * (row + y) + x, 0);
            consumer.setPixels(0, row, width, 1, cm, this.rowUnpackedBuffer, 0, 0);
        }
    }

    public byte[] asByteArray() {
        return null;
    }
}

