/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryByteRasterImage
extends JimiRasterImageSupport
implements ByteRasterImage,
BitRasterImage {
    protected byte[] imageData;
    protected byte[] pixelBuffer = new byte[1];

    public MemoryByteRasterImage(int width, int height, ColorModel cm) {
        super(width, height, cm);
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new byte[this.getWidth() * this.getHeight()];
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        ColorModel cm = this.getColorModel();
        try {
            for (int row = 0; row < height; ++row) {
                for (int column = 0; column < width; ++column) {
                    buffer[offset + column + row * scansize] = cm.getRGB(this.imageData[x + column + (y + row) * this.getWidth()] & 0xFF);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRowRGB(int y, int[] buffer, int offset) throws ImageAccessException {
        this.getRectangleRGB(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.getColorModel().getRGB(this.imageData[x + y * this.getWidth()] & 0xFF);
    }

    public void getRectangle(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(this.imageData, x + (y + row) * this.getWidth(), buffer, offset + row * scansize, this.getWidth());
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRow(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.getRectangle(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public byte getPixel(int x, int y) throws ImageAccessException {
        try {
            return this.imageData[x + y * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void setRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
        this.storeRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, byte value) throws ImageAccessException {
        this.setModified();
        this.sendPixel(x, y, value);
        this.storePixel(x, y, value);
    }

    public void storeRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(pixels, offset + row * scansize, this.imageData, x + (y + row) * this.getWidth(), width);
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void storeRow(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.storeRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void storePixel(int x, int y, byte value) throws ImageAccessException {
        try {
            this.imageData[x + y * this.getWidth()] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    protected void sendRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(x, y, width, height, this.getColorModel(), pixels, offset, this.getWidth());
    }

    protected void sendRow(int y, byte[] pixels, int offset) {
        this.sendRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    protected synchronized void sendPixel(int x, int y, byte value) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        this.pixelBuffer[0] = value;
        consumer.setPixels(x, y, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    public void setRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        byte[] buf = new byte[width * height];
        for (int row = 0; row < height; ++row) {
            JimiUtil.expandOneBitPixels(pixels, buf, width, scansize * row, width * row);
        }
        this.setRectangle(x, y, width, height, buf, 0, width);
    }

    public void setRowPacked(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectanglePacked(0, y, this.getWidth(), 1, pixels, offset, this.getWidth());
    }

    public void getRectanglePacked(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
    }

    public void getRowPacked(int y, byte[] buffer, int offset) throws ImageAccessException {
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        consumer.setPixels(0, 0, this.getWidth(), this.getHeight(), this.getColorModel(), this.imageData, 0, this.getWidth());
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        int offset = region.x + region.y * this.getWidth();
        consumer.setPixels(0, 0, region.width, region.height, this.getColorModel(), this.imageData, offset, this.getWidth());
    }

    protected ColorModel getAppropriateColorModel(ColorModel cm) {
        if (cm instanceof IndexColorModel) {
            return cm;
        }
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        byte[] alphas = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int rgb = cm.getRGB(i);
            alphas[i] = (byte)(rgb >>> 24);
            reds[i] = (byte)(rgb >>> 16);
            greens[i] = (byte)(rgb >>> 8);
            blues[i] = (byte)rgb;
        }
        cm = new IndexColorModel(8, 256, reds, greens, blues);
        return cm;
    }

    public byte[] asByteArray() {
        return this.imageData;
    }
}

