/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryIntRasterImage
extends JimiRasterImageSupport
implements ChanneledIntRasterImage {
    protected int[] imageData;
    protected int[] pixelBuffer = new int[1];

    public MemoryIntRasterImage(int width, int height, ColorModel cm) {
        super(width, height, cm);
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new int[this.getWidth() * this.getHeight()];
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        ColorModel cm = this.getColorModel();
        try {
            for (int row = 0; row < height; ++row) {
                for (int column = 0; column < width; ++column) {
                    buffer[offset + column + row * scansize] = cm.getRGB(this.imageData[x + column + (y + row) * this.getWidth()]);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRowRGB(int y, int[] buffer, int offset) throws ImageAccessException {
        this.getRectangleRGB(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.getColorModel().getRGB(this.imageData[x + y * this.getWidth()]);
    }

    public void getRectangle(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(this.imageData, x + (y + row) * this.getWidth(), buffer, offset + row * scansize, this.getWidth());
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRow(int y, int[] buffer, int offset) throws ImageAccessException {
        this.getRectangle(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public int getPixel(int x, int y) throws ImageAccessException {
        try {
            return this.imageData[x + y * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getChannelRectangle(int channel, int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            int[] rowBuf = new int[width];
            for (int row = 0; row < height; ++row) {
                this.getRowRGB(y + row, rowBuf, 0);
                for (int column = 0; column < width; ++column) {
                    buffer[offset + column + row * scansize] = (byte)(rowBuf[column] >>> channel);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getChannelRow(int channel, int y, byte[] buffer, int offset) throws ImageAccessException {
        this.getChannelRectangle(channel, 0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public void setRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        if (this.forceRGB) {
            this.toRGB(pixels, width, height, offset, scansize);
        }
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
        this.storeRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, int[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, int value) throws ImageAccessException {
        this.setModified();
        if (this.forceRGB) {
            value = this.toRGB(value);
        }
        this.sendPixel(x, y, value);
        this.storePixel(x, y, value);
    }

    public void storeRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(pixels, offset + row * scansize, this.imageData, x + (y + row) * this.getWidth(), width);
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void storeRow(int y, int[] pixels, int offset) throws ImageAccessException {
        this.storeRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void storePixel(int x, int y, int value) throws ImageAccessException {
        try {
            this.imageData[x + y * this.getWidth()] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void setChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.storeChannelRectangle(channel, x, y, width, height, pixels, offset, scansize);
    }

    public void setChannelRow(int channel, int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setChannelRectangle(channel, 0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setChannelPixel(int channel, int x, int y, byte value) throws ImageAccessException {
        this.setModified();
        int n = x + y * this.getWidth();
        this.imageData[n] = this.imageData[n] | (value & 0xFF) << channel;
    }

    public void storeChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                for (int column = 0; column < width; ++column) {
                    int n = x + column + (y + row) * this.getWidth();
                    this.imageData[n] = this.imageData[n] | (pixels[offset + column + row * scansize] & 0xFF) << channel;
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    protected void sendRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(x, y, width, height, this.getColorModel(), pixels, offset, this.getWidth());
    }

    protected void sendRow(int y, int[] pixels, int offset) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(0, y, this.getWidth(), 1, this.getColorModel(), pixels, offset, 0);
    }

    protected synchronized void sendPixel(int x, int y, int value) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        this.pixelBuffer[0] = value;
        consumer.setPixels(x, y, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        consumer.setPixels(0, 0, this.getWidth(), this.getHeight(), this.getColorModel(), this.imageData, 0, this.getWidth());
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        int offset = region.x + region.y * this.getWidth();
        consumer.setPixels(0, 0, region.width, region.height, this.getColorModel(), this.imageData, offset, this.getWidth());
    }

    protected void toRGB(int[] pixels, int width, int height, int offset, int scansize) {
        int pad = width - scansize;
        for (int row = 0; row < height; ++row) {
            for (int c = 0; c < width; ++c) {
                pixels[offset] = this.sourceColorModel.getRGB(pixels[offset]);
                ++offset;
            }
            offset += pad;
        }
    }

    protected int toRGB(int pixel) {
        return this.sourceColorModel.getRGB(pixel);
    }

    protected ColorModel getAppropriateColorModel(ColorModel cm) {
        if (cm instanceof IndexColorModel) {
            return cm;
        }
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            if (dcm.getRedMask() == 0xFF0000 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 255) {
                return cm;
            }
            if (dcm.getAlphaMask() == 0) {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        return ColorModel.getRGBdefault();
    }

    public int[] asIntArray() {
        return this.imageData;
    }
}

