/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.raster.LongRasterImage;
import com.sun.jimi.core.util.LongColorModel;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;

public class MemoryLongRasterImage
extends JimiRasterImageSupport
implements LongRasterImage {
    protected long[] imageData;
    protected int[] pixelBuffer;
    protected LongColorModel lcm;
    protected ColorModel rgbcm = ColorModel.getRGBdefault();

    public MemoryLongRasterImage(int width, int height, LongColorModel cm) {
        super(width, height, cm);
        this.lcm = cm;
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.imageData = new long[this.getWidth() * this.getHeight()];
        this.pixelBuffer = new int[this.getWidth()];
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                for (int column = 0; column < width; ++column) {
                    buffer[offset + column + row * scansize] = this.lcm.getRGB(this.imageData[x + column + (y + row) * this.getWidth()] & 0xFFL);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRowRGB(int y, int[] buffer, int offset) throws ImageAccessException {
        this.getRectangleRGB(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.lcm.getRGB(this.imageData[x + y * this.getWidth()]);
    }

    public void getRectangle(int x, int y, int width, int height, long[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(this.imageData, x + (y + row) * this.getWidth(), buffer, offset + row * scansize, this.getWidth());
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void getRow(int y, long[] buffer, int offset) throws ImageAccessException {
        this.getRectangle(0, y, this.getWidth(), 1, buffer, offset, 0);
    }

    public long getPixel(int x, int y) throws ImageAccessException {
        try {
            return this.imageData[x + y * this.getWidth()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void setRectangle(int x, int y, int width, int height, long[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
        this.storeRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, long[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, long value) throws ImageAccessException {
        this.setModified();
        this.setPixel(x, y, value);
        this.sendPixel(x, y, value);
    }

    public void storeRectangle(int x, int y, int width, int height, long[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(pixels, offset + row * scansize, this.imageData, x + (y + row) * this.getWidth(), width);
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void storeRow(int y, long[] pixels, int offset) throws ImageAccessException {
        this.storeRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void storePixel(int x, int y, long value) throws ImageAccessException {
        try {
            this.imageData[x + y * this.getWidth()] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    protected synchronized void sendRectangle(int x, int y, int width, int height, long[] pixels, int offset, int scansize) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        for (int row = 0; row < height; ++row) {
            for (int i = 0; i < width; ++i) {
                this.pixelBuffer[i] = this.lcm.getRGB(pixels[x + offset]);
            }
            consumer.setPixels(x, y + row, width, 1, this.rgbcm, this.pixelBuffer, 0, 0);
        }
    }

    protected void sendRow(int y, long[] pixels, int offset) {
        this.sendRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    protected synchronized void sendPixel(int x, int y, long value) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        this.pixelBuffer[0] = this.lcm.getRGB(value);
        consumer.setPixels(x, y, 1, 1, this.rgbcm, this.pixelBuffer, 0, 1);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        this.sendRectangle(0, 0, this.getWidth(), this.getHeight(), this.imageData, 0, this.getWidth());
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        this.sendRectangle(region.x, region.y, region.width, region.height, this.imageData, region.x + region.y * this.getWidth(), this.getWidth());
    }
}

