/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryByteRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class OneshotByteRasterImage
extends MemoryByteRasterImage {
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    public OneshotByteRasterImage(int width, int height, ColorModel cm, boolean onebit) {
        super(width, height, cm);
        this.rowByteWidth = (width + 7) / 8;
        if (onebit && !(cm instanceof IndexColorModel)) {
            int color0 = cm.getRGB(0);
            int color1 = cm.getRGB(1);
            byte[] alphas = new byte[]{(byte)(color0 >> 24 & 0xFF), (byte)(color1 >> 24 & 0xFF)};
            byte[] reds = new byte[]{(byte)(color0 >> 16 & 0xFF), (byte)(color1 >> 16 & 0xFF)};
            byte[] greens = new byte[]{(byte)(color0 >> 8 & 0xFF), (byte)(color1 >> 8 & 0xFF)};
            byte[] blues = new byte[]{(byte)(color0 >> 0 & 0xFF), (byte)(color1 >> 0 & 0xFF)};
            IndexColorModel icm = new IndexColorModel(1, 2, reds, greens, blues, alphas);
            this.setColorModel(icm);
        }
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
        this.rowUnpackedBuffer = new byte[this.rowByteWidth * 8];
    }

    public void setRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setPixel(int x, int y, byte value) throws ImageAccessException {
        this.setModified();
        this.sendPixel(x, y, value);
    }

    protected void sendRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(x, y, width, height, this.getColorModel(), pixels, offset, scansize);
    }

    protected void sendRow(int y, byte[] pixels, int offset) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        consumer.setPixels(0, y, this.getWidth(), 1, this.getColorModel(), pixels, offset, 0);
    }

    protected synchronized void sendPixel(int x, int y, byte value) {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        this.pixelBuffer[0] = value;
        consumer.setPixels(x, y, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 1);
    }

    public void setRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(x, y, width, height, pixels, offset, scansize);
    }

    public void setRowPacked(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectanglePacked(0, y, this.getWidth(), 1, pixels, offset, this.getWidth());
    }

    public void getRectanglePacked(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
    }

    public void getRowPacked(int y, byte[] buffer, int offset) throws ImageAccessException {
    }

    protected void sendRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (!this.hasDirectConsumer()) {
            return;
        }
        MulticastImageConsumer consumer = this.getDirectConsumer();
        for (int row = 0; row < height; ++row) {
            JimiUtil.expandOneBitPixels(pixels, this.rowUnpackedBuffer, width, row * width * 8, 0);
            consumer.setPixels(x, y + row, width, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, width);
        }
    }

    protected void addWaitingConsumer(ImageConsumer consumer) {
        consumer.imageComplete(1);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        throw new ImageAccessException();
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        throw new ImageAccessException();
    }
}

