/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryIntRasterImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;

public class OneshotIntRasterImage
extends MemoryIntRasterImage {
    protected int[] pixelBuffer = new int[1];

    public OneshotIntRasterImage(int width, int height, ColorModel cm) {
        super(width, height, cm);
        try {
            this.initStorage();
        }
        catch (JimiException e) {
            this.setError();
        }
    }

    protected void initStorage() throws JimiException {
    }

    public void setRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, int[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, int value) throws ImageAccessException {
        this.setModified();
        this.sendPixel(x, y, value);
    }

    public void storeRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                System.arraycopy(pixels, offset + row * scansize, this.imageData, x + (y + row) * this.getWidth(), width);
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    public void storeRow(int y, int[] pixels, int offset) throws ImageAccessException {
    }

    public void storePixel(int x, int y, int value) throws ImageAccessException {
    }

    public void setChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
    }

    public void setChannelRow(int channel, int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setChannelRectangle(channel, 0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setChannelPixel(int channel, int x, int y, byte value) throws ImageAccessException {
        this.setModified();
        int n = x + y * this.getWidth();
        this.imageData[n] = this.imageData[n] | (value & 0xFF) << channel;
    }

    public void storeChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            for (int row = 0; row < height; ++row) {
                for (int column = 0; column < width; ++column) {
                    int n = x + column + (y + row) * this.getWidth();
                    this.imageData[n] = this.imageData[n] | (pixels[offset + column + row * scansize] & 0xFF) << channel;
                }
            }
        }
        catch (RuntimeException e) {
            throw new ImageAccessException(e.toString());
        }
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        throw new ImageAccessException();
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        throw new ImageAccessException();
    }
}

