/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryByteRasterImage;
import com.sun.jimi.core.vmem.BytePageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;

public class VMemByteRasterImage
extends MemoryByteRasterImage {
    protected BytePageMapper pageMapper;
    protected byte[] rowBuffer;
    protected byte[] pixelBuf = new byte[1];

    public VMemByteRasterImage(RandomAccessStorage storage, int width, int height, ColorModel cm) throws JimiException {
        super(width, height, cm);
        this.pageMapper = new BytePageMapper(storage, new Dimension(width, height), 2048);
    }

    protected void initStorage() throws JimiException {
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        ColorModel cm = this.getColorModel();
        if (this.rowBuffer == null) {
            this.rowBuffer = new byte[this.getWidth()];
        }
        for (int row = 0; row < height; ++row) {
            this.getRectangle(x, y + row, width, 1, this.rowBuffer, 0, 0);
            for (int i = 0; i < width; ++i) {
                buffer[offset++] = cm.getRGB(this.rowBuffer[i] & 0xFF);
            }
            offset += scansize - width;
        }
    }

    public void getRectangle(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            this.pageMapper.getRectangle(x, y, width, height, buffer, offset, scansize);
        }
        catch (IOException ioe) {
            throw new ImageAccessException(ioe.getMessage());
        }
    }

    public byte getPixel(int x, int y) throws ImageAccessException {
        this.getRectangle(x, y, 1, 1, this.pixelBuf, 0, 0);
        return this.pixelBuf[0];
    }

    public int getRectangleRGB(int x, int y) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(x, y));
    }

    public void storeRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        try {
            this.pageMapper.setRectangle(x, y, width, height, pixels, offset, scansize);
        }
        catch (IOException ioe) {
            throw new ImageAccessException(ioe.getMessage());
        }
    }

    public void storePixel(int x, int y, byte value) throws ImageAccessException {
        this.pixelBuf[0] = value;
        this.setRectangle(x, y, 1, 1, this.pixelBuf, 0, 0);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        int sendHeight;
        int bufferHeight = this.pageMapper.getPageDimensions().height;
        byte[] buffer = new byte[this.getWidth() * bufferHeight];
        int imageHeight = this.getHeight();
        int width = this.getWidth();
        ColorModel model = this.getColorModel();
        for (int y = 0; y < imageHeight; y += sendHeight) {
            sendHeight = Math.min(bufferHeight, imageHeight - y);
            this.getRectangle(0, y, width, sendHeight, buffer, 0, width);
            consumer.setPixels(0, y, width, sendHeight, this.colorModel, buffer, 0, width);
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        try {
            int sendHeight;
            int bufferHeight = this.pageMapper.getPageDimensions().height;
            int rx = region.x;
            int ry = region.y;
            int rwidth = region.width;
            int rheight = region.height;
            ColorModel cm = this.getColorModel();
            int bufferedRows = 5;
            bufferedRows = Math.max(1, bufferedRows);
            byte[] buffer = new byte[rwidth * bufferedRows];
            for (int y = 0; y < rheight; y += sendHeight) {
                sendHeight = Math.min(bufferedRows, rheight - y);
                this.getRectangle(rx, y + ry, rwidth, sendHeight, buffer, 0, rwidth);
                consumer.setPixels(0, y, rwidth, sendHeight, cm, buffer, 0, rwidth);
            }
        }
        catch (Exception e) {
            throw new ImageAccessException();
        }
    }

    public byte[] asByteArray() {
        return null;
    }
}

