/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryIntRasterImage;
import com.sun.jimi.core.vmem.IntPageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;

public class VMemIntRasterImage
extends MemoryIntRasterImage {
    protected IntPageMapper pageMapper;
    int[] pixelBuf = new int[1];

    public VMemIntRasterImage(RandomAccessStorage storage, int width, int height, ColorModel cm) throws JimiException {
        super(width, height, cm);
        this.pageMapper = new IntPageMapper(storage, new Dimension(width, height), 2048);
    }

    protected void initStorage() throws JimiException {
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[width];
        }
        for (int row = 0; row < height; ++row) {
            this.getRow(y + row, this.rowBuf, 0);
            int srcindex = 0;
            int destindex = 0;
            for (int column = 0; column < width; ++column) {
                buffer[row * scansize + destindex++ + offset] = this.colorModel.getRGB(this.rowBuf[srcindex++]);
            }
        }
    }

    public void getRectangle(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        try {
            this.pageMapper.getRectangle(x, y, width, height, buffer, offset, scansize);
        }
        catch (IOException ioe) {
            throw new ImageAccessException(ioe.getMessage());
        }
    }

    public synchronized int getPixel(int x, int y) throws ImageAccessException {
        this.getRectangle(x, y, 1, 1, this.pixelBuf, 0, 0);
        return this.pixelBuf[0];
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.colorModel.getRGB(this.getPixel(x, y));
    }

    public void storeRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        try {
            this.pageMapper.setRectangle(x, y, width, height, pixels, offset, scansize);
        }
        catch (IOException ioe) {
            throw new ImageAccessException(ioe.getMessage());
        }
    }

    public void storeChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        this.setModified();
        try {
            this.pageMapper.setChannelRectangle(channel, x, y, width, height, pixels, offset, scansize);
        }
        catch (IOException ioe) {
            throw new ImageAccessException(ioe.getMessage());
        }
    }

    public synchronized void storePixel(int x, int y, int value) throws ImageAccessException {
        this.pixelBuf[0] = value;
        this.setRectangle(x, y, 0, 0, this.pixelBuf, 0, 0);
    }

    protected void sendToConsumerFully(ImageConsumer consumer) throws ImageAccessException {
        int sendHeight;
        int bufferHeight = this.pageMapper.getPageDimensions().height;
        int[] buffer = new int[this.getWidth() * bufferHeight];
        int imageHeight = this.getHeight();
        int width = this.getWidth();
        ColorModel model = this.getColorModel();
        for (int y = 0; y < imageHeight; y += sendHeight) {
            sendHeight = Math.min(bufferHeight, imageHeight - y);
            this.getRectangle(0, y, width, sendHeight, buffer, 0, width);
            consumer.setPixels(0, y, width, sendHeight, this.colorModel, buffer, 0, width);
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer consumer, Rectangle region) throws ImageAccessException {
        int sendHeight;
        int bufferHeight = this.pageMapper.getPageDimensions().height;
        int rx = region.x;
        int ry = region.y;
        int rwidth = region.width;
        int rheight = region.height;
        ColorModel cm = this.getColorModel();
        int bufferedRows = this.getWidth() * bufferHeight / rwidth;
        bufferedRows = Math.max(1, bufferedRows);
        int[] buffer = new int[rwidth * bufferedRows];
        for (int y = 0; y < rheight; y += sendHeight) {
            sendHeight = Math.min(bufferedRows, rheight - y);
            this.getRectangle(rx, y + ry, rwidth, sendHeight, buffer, 0, rwidth);
            consumer.setPixels(0, y, rwidth, sendHeight, cm, buffer, 0, rwidth);
        }
    }

    public int[] asIntArray() {
        return null;
    }
}

