/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster.stamped;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.stamped.StampedByteRasterImage;
import com.sun.jimi.core.util.StampImage;

public class StampedBitRasterImage
extends StampedByteRasterImage
implements BitRasterImage {
    protected BitRasterImage image;
    static int rowc = 0;

    public StampedBitRasterImage(BitRasterImage image) {
        super(image);
        this.image = image;
        this.stampx -= this.stampx % 8;
    }

    public void setRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (this.error) {
            for (int row = 0; row < height; ++row) {
                int rowindex = row * scansize;
                for (int col = 0; col < width; ++col) {
                    pixels[rowindex + col] = -1;
                }
            }
        }
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height >= this.stampy && y < this.stampy + this.stampheight) {
            int startx = Math.max(x, this.stampx);
            int endx = Math.min(x + width, this.stampx + this.stampwidth);
            int starty = Math.max(y, this.stampy);
            int endy = Math.min(y + height, this.stampy + this.stampheight);
            try {
                for (int r = starty; r < endy; ++r) {
                    for (int c = startx; c < endx; ++c) {
                        pixels[offset + (r - y) * scansize + (c - x)] = StampImage.pixels[(r - this.stampy) % 30 * 46 + (c - this.stampx) % 46] == -1 ? (byte)0 : 1;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.image.setRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRectanglePacked(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (this.error) {
            for (int row = 0; row < height; ++row) {
                int rowindex = row * scansize;
                for (int col = 0; col < width >> 3; ++col) {
                    pixels[rowindex + col] = -1;
                }
            }
        }
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height > this.stampy && y < this.stampy + this.stampheight) {
            int startx = this.stampx / 8;
            int starty = y;
            int endx = startx + (this.stampwidth + 7) / 8;
            int endy = starty + 1;
            int byteWidth = (this.stampwidth + 7) / 8;
            int row = y - this.stampy;
            try {
                for (int column = startx; column < endx; ++column) {
                    pixels[offset + column] = StampImage.packedPixels[row % 30 * 6 + (column - startx) % 6];
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.image.setRectanglePacked(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, byte value) throws ImageAccessException {
        if (this.error) {
            value = 1;
        }
        if (x >= this.stampx && x < this.stampx + this.stampwidth && y >= this.stampy && y < this.stampy + this.stampheight) {
            value = StampImage.pixels[(y - this.stampy) % 30 * 46 + (x - this.stampx) % 46] == -1 ? (byte)0 : 1;
        }
        this.image.setPixel(x, y, value);
    }

    public void getRectangle(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.image.getRectangle(x, y, width, height, buffer, offset, scansize);
    }

    public void getRow(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.image.getRow(y, buffer, offset);
    }

    public byte getPixel(int x, int y) throws ImageAccessException {
        return this.image.getPixel(x, y);
    }

    public void setRowPacked(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectanglePacked(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void getRectanglePacked(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.image.getRectanglePacked(x, y, width, height, buffer, offset, scansize);
    }

    public void getRowPacked(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.image.getRowPacked(y, buffer, offset);
    }
}

