/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster.stamped;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.stamped.StampedRasterImageSupport;
import com.sun.jimi.core.util.StampImage;
import java.awt.image.IndexColorModel;

public class StampedByteRasterImage
extends StampedRasterImageSupport
implements ByteRasterImage {
    protected ByteRasterImage image;
    protected ByteRasterImage stampImage;
    protected byte background;
    protected byte[] mapping;

    public StampedByteRasterImage(ByteRasterImage image) {
        super(image);
        this.image = image;
        this.mapping = this.getColorModel() instanceof IndexColorModel ? StampImage.mapPalette((IndexColorModel)this.getColorModel()) : new byte[StampImage.palette.length];
    }

    public void setRectangle(int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        byte[] stamp = StampImage.bytePixels;
        if (this.error) {
            for (int row = 0; row < height; ++row) {
                int rowindex = row * scansize;
                for (int col = 0; col < width; ++col) {
                    pixels[rowindex + col] = 0;
                }
            }
        }
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height >= this.stampy && y < this.stampy + this.stampheight) {
            int startx = Math.max(x, this.stampx);
            int endx = Math.min(x + width, this.stampx + this.stampwidth);
            int starty = Math.max(y, this.stampy);
            int endy = Math.min(y + height, this.stampy + this.stampheight);
            try {
                for (int r = starty; r < endy; ++r) {
                    for (int c = startx; c < endx; ++c) {
                        pixels[offset + (r - y) * scansize + (c - x)] = this.mapping[stamp[(r - this.stampy) % 30 * 46 + (c - this.stampx) % 46]];
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.image.setRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, byte value) throws ImageAccessException {
        if (this.error) {
            value = this.background;
        }
        if (x >= this.stampx && x < this.stampx + this.stampwidth && y >= this.stampy && y < this.stampy + this.stampheight) {
            value = this.stampImage.getPixel((x - this.stampx) % 46, (y - this.stampy) % 30);
        }
        this.image.setPixel(x, y, value);
    }

    public void getRectangle(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.image.getRectangle(x, y, width, height, buffer, offset, scansize);
    }

    public void getRow(int y, byte[] buffer, int offset) throws ImageAccessException {
        this.image.getRow(y, buffer, offset);
    }

    public byte getPixel(int x, int y) throws ImageAccessException {
        return this.image.getPixel(x, y);
    }
}

