/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster.stamped;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.raster.ChanneledIntRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.stamped.StampedRasterImageSupport;
import com.sun.jimi.core.util.StampImage;

public class StampedIntRasterImage
extends StampedRasterImageSupport
implements ChanneledIntRasterImage {
    protected IntRasterImage image;
    protected ChanneledIntRasterImage channeledImage;

    public StampedIntRasterImage(IntRasterImage image) {
        super(image);
        this.image = image;
        if (image instanceof ChanneledIntRasterImage) {
            this.channeledImage = (ChanneledIntRasterImage)image;
        }
    }

    public void setRectangle(int x, int y, int width, int height, int[] pixels, int offset, int scansize) throws ImageAccessException {
        if (this.error) {
            for (int row = 0; row < height; ++row) {
                int rowindex = row * scansize;
                for (int col = 0; col < width; ++col) {
                    pixels[rowindex + col] = -1;
                }
            }
        }
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height >= this.stampy && y < this.stampy + this.stampheight) {
            int startx = Math.max(x, this.stampx);
            int endx = Math.min(x + width, this.stampx + this.stampwidth);
            int starty = Math.max(y, this.stampy);
            int endy = Math.min(y + height, this.stampy + this.stampheight);
            for (int r = starty; r < endy; ++r) {
                for (int c = startx; c < endx; ++c) {
                    pixels[offset + (r - y) * scansize + (c - x)] = StampImage.pixels[(r - this.stampy) % 30 * 46 + (c - this.stampx) % 46];
                }
            }
        }
        this.image.setRectangle(x, y, width, height, pixels, offset, scansize);
    }

    public void setRow(int y, int[] pixels, int offset) throws ImageAccessException {
        this.setRectangle(0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setPixel(int x, int y, int value) throws ImageAccessException {
        if (this.error) {
            value = -1;
        }
        if (x >= this.stampx && x < this.stampx + this.stampwidth && y >= this.stampy && y < this.stampy + this.stampheight) {
            value = StampImage.pixels[(y - this.stampy) * 46 + (x - this.stampx)];
        }
        this.image.setPixel(x, y, value);
    }

    public void getRectangle(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
    }

    public void getRow(int y, int[] buffer, int offset) throws ImageAccessException {
    }

    public int getPixel(int x, int y) throws ImageAccessException {
        return this.image.getPixel(x, y);
    }

    public void getChannelRectangle(int channel, int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.image.getChannelRectangle(channel, x, y, width, height, buffer, offset, scansize);
    }

    public void getChannelRow(int channel, int y, byte[] buffer, int offset) throws ImageAccessException {
        this.image.getChannelRow(channel, y, buffer, offset);
    }

    public void setChannelRectangle(int channel, int x, int y, int width, int height, byte[] pixels, int offset, int scansize) throws ImageAccessException {
        if (this.error) {
            for (int row = 0; row < height; ++row) {
                int rowindex = row * scansize;
                for (int col = 0; col < width; ++col) {
                    pixels[rowindex + col] = -1;
                }
            }
        }
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height >= this.stampy && y < this.stampy + this.stampheight) {
            int startx = Math.max(x, this.stampx);
            int endx = Math.min(x + width, this.stampx + this.stampwidth);
            int starty = Math.max(y, this.stampy);
            int endy = Math.min(y + height, this.stampy + this.stampheight);
            for (int r = starty; r < endy; ++r) {
                for (int c = startx; c < endx; ++c) {
                    pixels[offset + (r - y) * scansize + (c - x)] = (byte)(StampImage.pixels[(r - this.stampy) % 30 * 46 + (c - this.stampx) % 46] >>> channel);
                }
            }
        }
        this.channeledImage.setChannelRectangle(channel, x, y, width, height, pixels, offset, scansize);
    }

    public void setChannelRow(int channel, int y, byte[] pixels, int offset) throws ImageAccessException {
        this.setChannelRectangle(channel, 0, y, this.getWidth(), 1, pixels, offset, 0);
    }

    public void setChannelPixel(int channel, int x, int y, byte value) throws ImageAccessException {
        if (x >= this.stampx && x < this.stampx + this.stampwidth && y >= this.stampy && y < this.stampy + this.stampheight) {
            value = (byte)(StampImage.pixels[(y - this.stampy) % 30 * 46 + (x - this.stampx) % 46] >>> channel);
        }
        this.channeledImage.setChannelPixel(channel, x, y, value);
    }
}

