/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster.stamped;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Random;

public abstract class StampedRasterImageSupport
implements MutableJimiRasterImage {
    protected MutableJimiRasterImage wrappedImage;
    protected int stampx;
    protected int stampy;
    protected int stampwidth;
    protected int stampheight;
    protected int stampAreaWidth;
    protected int stampAreaHeight;
    protected int horizStamps;
    protected int vertStamps;
    protected static int imageIndex;
    protected static int nextError;
    protected static final int ERROR_SET = 4;
    protected boolean error;
    protected static Random random;

    protected StampedRasterImageSupport(MutableJimiRasterImage image) {
        this.wrappedImage = image;
        this.horizStamps = Math.max(1, image.getWidth() / 46 / 5);
        this.vertStamps = Math.max(1, image.getHeight() / 30 / 5);
        this.stampwidth = Math.min(46 * this.horizStamps, image.getWidth());
        this.stampheight = Math.min(30 * this.vertStamps, image.getHeight());
        this.stampx = Math.max(0, (image.getWidth() - this.stampwidth) / 2);
        this.stampy = Math.max(0, (image.getHeight() - this.stampheight) / 2);
    }

    public Hashtable getProperties() {
        return this.wrappedImage.getProperties();
    }

    protected static synchronized boolean decideError() {
        return false;
    }

    public ImageProducer getImageProducer() {
        return this.wrappedImage.getImageProducer();
    }

    public ImageProducer getCroppedImageProducer(int x, int y, int w, int h) {
        return this.wrappedImage.getCroppedImageProducer(x, y, w, h);
    }

    public boolean isError() {
        return this.wrappedImage.isError();
    }

    public void waitFinished() {
        this.wrappedImage.waitFinished();
    }

    public JimiImageFactory getFactory() {
        return this.wrappedImage.getFactory();
    }

    public void waitInfoAvailable() {
        this.wrappedImage.waitInfoAvailable();
    }

    public void setImageConsumerHints(int hints) {
        this.wrappedImage.setImageConsumerHints(hints);
    }

    public void setFinished() {
        this.wrappedImage.setFinished();
    }

    public void setError() {
        this.wrappedImage.setError();
    }

    public void setDecodingController(JimiDecodingController controller) {
        this.wrappedImage.setDecodingController(controller);
    }

    public int getWidth() {
        return this.wrappedImage.getWidth();
    }

    public int getHeight() {
        return this.wrappedImage.getHeight();
    }

    public ColorModel getColorModel() {
        return this.wrappedImage.getColorModel();
    }

    public void getRectangleRGB(int x, int y, int width, int height, int[] buffer, int offset, int scansize) throws ImageAccessException {
        this.wrappedImage.getRectangleRGB(x, y, width, height, buffer, offset, scansize);
    }

    public void getRowRGB(int y, int[] buffer, int offset) throws ImageAccessException {
        this.wrappedImage.getRowRGB(y, buffer, offset);
    }

    public int getPixelRGB(int x, int y) throws ImageAccessException {
        return this.wrappedImage.getPixelRGB(x, y);
    }

    public void getChannelRectangle(int channel, int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.wrappedImage.getChannelRectangle(channel, x, y, width, height, buffer, offset, scansize);
    }

    public void getRectangleRGBChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.wrappedImage.getRectangleRGBChannels(x, y, width, height, buffer, offset, scansize);
    }

    public void getRectangleARGBChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.wrappedImage.getRectangleARGBChannels(x, y, width, height, buffer, offset, scansize);
    }

    public void getRectangleRGBAChannels(int x, int y, int width, int height, byte[] buffer, int offset, int scansize) throws ImageAccessException {
        this.wrappedImage.getRectangleRGBAChannels(x, y, width, height, buffer, offset, scansize);
    }

    public void setOptions(FormatOptionSet options) {
        this.wrappedImage.setOptions(options);
    }

    public FormatOptionSet getOptions() {
        return this.wrappedImage.getOptions();
    }

    public int[] asIntArray() {
        if (this.wrappedImage instanceof IntRasterImage) {
            return ((IntRasterImage)this.wrappedImage).asIntArray();
        }
        return null;
    }

    public byte[] asByteArray() {
        if (this.wrappedImage instanceof ByteRasterImage) {
            return ((ByteRasterImage)this.wrappedImage).asByteArray();
        }
        return null;
    }

    public void setWaitForOptions(boolean wait) {
        this.wrappedImage.setWaitForOptions(wait);
    }

    public boolean mustWaitForOptions() {
        return this.wrappedImage.mustWaitForOptions();
    }

    static {
        random = new Random();
        nextError = Math.abs(random.nextInt() % 4);
    }
}

