/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.util.ExpandableArray;
import java.awt.Rectangle;

public class AreaCoverage {
    int width;
    int height;
    ExpandableArray rectangles;

    public AreaCoverage(int w, int h) {
        this.width = w;
        this.height = h;
        this.reset();
    }

    public void reset() {
        this.rectangles = new ExpandableArray();
    }

    public void add(int x, int y, int width, int height) {
        if (this.contains(x, y, width, height)) {
            return;
        }
        Rectangle newR = new Rectangle(x, y, width, height);
        int newIndex = this.rectangles.addElement(newR);
        this.mergeRecords(newIndex);
    }

    public void add(int row) {
        this.add(0, row, this.width, 1);
    }

    public boolean contains(int row) {
        return this.contains(0, row, this.width, 1);
    }

    public boolean contains(int x, int y, int w, int h) {
        int limit = this.rectangles.size();
        for (int i = this.rectangles.size() - 1; i >= 0; --i) {
            Rectangle r = (Rectangle)this.rectangles.elementAt(i);
            if (!r.contains(x, y) || !r.contains(x + w - 1, y + h - 1)) continue;
            return true;
        }
        return false;
    }

    protected void mergeRecords(int idx) {
        if (this.rectangles.size() < 2) {
            return;
        }
        Rectangle mr = (Rectangle)this.rectangles.elementAt(idx);
        this.rectangles.removeElementAt(idx);
        for (int i = 0; i < this.rectangles.size(); ++i) {
            Rectangle r = (Rectangle)this.rectangles.elementAt(i);
            if (mr.x + mr.width == r.x) {
                if (mr.height != r.height || mr.y != r.y) continue;
                r.setBounds(mr.x, r.y, r.width + mr.width, r.height);
                this.mergeRecords(i);
                return;
            }
            if (mr.x - 1 == r.x + r.width - 1) {
                if (mr.height != r.height || mr.y != r.y) continue;
                r.setBounds(r.x, r.y, r.width + mr.width, r.height);
                this.mergeRecords(i);
                return;
            }
            if (mr.y + mr.height == r.y) {
                if (mr.width != r.width || mr.x != r.x) continue;
                r.setBounds(r.x, mr.y, r.width, r.height + mr.height);
                this.mergeRecords(i);
                return;
            }
            if (mr.y - 1 != r.y + r.height - 1 || mr.width != r.width || mr.x != r.x) continue;
            r.setBounds(r.x, r.y, r.width, r.height + mr.height);
            this.mergeRecords(i);
            return;
        }
        this.rectangles.addElement(mr);
    }

    public Rectangle getBounds() {
        int minX = this.width;
        boolean maxX = false;
        int minY = this.height;
        boolean maxY = false;
        Rectangle r = new Rectangle();
        int i = this.rectangles.size();
        while (--i >= 0) {
            r.add((Rectangle)this.rectangles.elementAt(i));
        }
        return r;
    }
}

