/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

public class BinOps {
    public static void xor(byte[] value, byte[] xor) {
        BinOps.xor(value, xor, 0, value.length);
    }

    public static void xor(byte[] value, byte[] xor, int start, int count) {
        for (int i = 0; i < count; ++i) {
            int n = start + i;
            value[n] = (byte)(value[n] ^ xor[i % xor.length]);
        }
    }

    public static void rotateLeft(byte[] value, int bits) {
        BinOps.rol(value, bits, 0, value.length);
    }

    public static void rol(byte[] value, int bits, int start, int count) {
        int overflow = bits % 8;
        int bytes = bits / 8;
        if (overflow == 0) {
            byte[] work = (byte[])value.clone();
            System.arraycopy(work, start + bytes, value, start, count - bytes);
            System.arraycopy(work, start, value, start + count - bytes, bytes);
        } else {
            int leftoverMask = (1 << overflow) - 1;
            byte[] work = (byte[])value.clone();
            for (int i = 0; i < count; ++i) {
                int lhs = start + (i + bytes) % count;
                int rhs = start + (i + bytes + 1) % count;
                byte val = (byte)(work[lhs] << overflow);
                value[start + (i + bytes) % count] = val = (byte)(val | (byte)(work[rhs] >> 8 - overflow & leftoverMask));
            }
        }
    }

    public static void ror(byte[] value, int bits) {
        BinOps.ror(value, bits, 0, value.length);
    }

    public static void ror(byte[] value, int bits, int start, int count) {
        int overflow = bits % 8;
        int bytes = bits / 8;
        if (overflow == 0) {
            byte[] work = (byte[])value.clone();
            System.arraycopy(work, start, value, start + bytes, count - bytes);
            System.arraycopy(work, start + count - bytes, value, start, bytes);
        } else {
            int leftoverMask = (1 << 8 - overflow) - 1;
            byte[] work = (byte[])value.clone();
            for (int i = 0; i < count; ++i) {
                int lhs = start + (i + bytes) % count;
                int rhs = start + (i + bytes + 1) % count;
                byte val = (byte)(work[lhs] << 8 - overflow);
                value[start + (i + bytes + 1) % count] = val = (byte)(val | (byte)(work[rhs] >>> overflow & leftoverMask));
            }
        }
    }

    public static void add(byte[] value, byte[] add) {
        BinOps.add(value, add, 0, value.length);
    }

    public static void add(byte[] value, byte[] add, int start, int count) {
        for (int i = 0; i < count; ++i) {
            int n = start + i;
            value[n] = (byte)(value[n] + add[i % add.length]);
        }
    }

    public static void sub(byte[] value, byte[] sub) {
        BinOps.sub(value, sub, 0, value.length);
    }

    public static void sub(byte[] value, byte[] sub, int start, int count) {
        for (int i = 0; i < count; ++i) {
            int n = start + i;
            value[n] = (byte)(value[n] - sub[i % sub.length]);
        }
    }

    public static void main(String[] args) {
        int i;
        byte[] testData = new byte[]{0, 2, 3};
        for (i = 0; i < testData.length; ++i) {
            System.out.println(Integer.toBinaryString(testData[i] & 0xFF));
        }
        System.out.println(" =>");
        BinOps.sub(testData, new byte[]{1});
        for (i = 0; i < testData.length; ++i) {
            System.out.println(Integer.toString(testData[i] & 0xFF));
        }
    }
}

