/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.OctreeCallback;
import com.sun.jimi.core.util.OctreeNode;
import com.sun.jimi.util.ExpandableArray;

public final class ColorOctree
implements OctreeCallback {
    int leaf_level = 8;
    int maxColors;
    OctreeNode tree;
    ExpandableArray[] reduce;
    int numLeaves = 0;
    protected boolean alpha;
    int cacheCount;
    public ExpandableArray cachedONodes;
    public static final int MAXCACHE = 25;
    boolean caching;

    public ColorOctree(int maxColors) {
        this.maxColors = maxColors;
        this.tree = new OctreeNode(this);
        this.reduce = new ExpandableArray[8];
        for (int i = 0; i < 8; ++i) {
            this.reduce[i] = new ExpandableArray(10, 10);
        }
        this.cachedONodes = new ExpandableArray(10);
    }

    public void addColor(int color) {
        if ((color & 0xFF000000) == 0) {
            if (!this.alpha) {
                this.alpha = true;
                --this.maxColors;
                if (this.numLeaves > this.maxColors) {
                    this.reduceColors();
                }
            }
        } else {
            this.numLeaves += this.tree.insertColor(color, this.leaf_level);
            if (this.numLeaves > this.maxColors) {
                this.reduceColors();
            }
        }
    }

    public void addColor(int[] color) {
        for (int i = 0; i < color.length; ++i) {
            if ((color[i] & 0xFF000000) == 0) {
                if (this.alpha) continue;
                this.alpha = true;
                --this.maxColors;
                if (this.numLeaves <= this.maxColors) continue;
                this.reduceColors();
                continue;
            }
            this.numLeaves += this.tree.insertColor(color[i], this.leaf_level);
            if (this.numLeaves <= this.maxColors) continue;
            this.reduceColors();
        }
    }

    public boolean hasAlpha() {
        return this.alpha;
    }

    void reduceColors() {
        this.caching = true;
        OctreeNode on = this.getReducible();
        this.numLeaves -= on.collapseOctree();
        on.leaf = true;
        ++this.numLeaves;
        if (on.level < this.leaf_level - 1) {
            this.leaf_level = on.level + 1;
        }
    }

    int getPalette(byte[] p) {
        byte[] buf = new byte[1024];
        int size = this.tree.createPalette(buf, 0) / 3;
        size = Math.min(size, this.maxColors);
        int bufidx = 0;
        int pidx = 0;
        while (bufidx < size * 3) {
            p[pidx++] = buf[bufidx++];
            p[pidx++] = buf[bufidx++];
            p[pidx++] = buf[bufidx++];
            p[pidx++] = -1;
        }
        return this.alpha ? size + 1 : size;
    }

    int quantizeColor(int color) {
        if ((color & 0xFF000000) == 0) {
            return this.maxColors * 3;
        }
        return this.tree.quantizeColor(color);
    }

    public void markReducible(OctreeNode on) {
        on.marked = true;
        this.reduce[on.level].addElement(on);
    }

    public OctreeNode getReducible() {
        OctreeNode onLargest = null;
        int i = this.leaf_level - 1;
        while (this.reduce[i].size() == 0) {
            --i;
        }
        ExpandableArray v = this.reduce[i];
        int vSize = v.size();
        if (vSize > 0) {
            int largestIndex = 0;
            onLargest = (OctreeNode)v.elementAt(0);
            for (int j = 1; j < vSize; ++j) {
                OctreeNode on = (OctreeNode)v.elementAt(j);
                if (on.count < onLargest.count) continue;
                onLargest = on;
                largestIndex = j;
            }
            v.removeElementAt(largestIndex);
        }
        return onLargest;
    }

    public OctreeNode getONode(OctreeCallback oc, int level) {
        OctreeNode on;
        if (this.cacheCount > 0) {
            on = (OctreeNode)this.cachedONodes.lastElement();
            this.cachedONodes.removeElementAt(this.cacheCount - 1);
            --this.cacheCount;
            on.setFields(oc, level);
        } else {
            on = new OctreeNode(oc, level);
        }
        return on;
    }

    public void cacheONode(OctreeNode on) {
        int n = on.level;
        OctreeNode.levCounts[n] = OctreeNode.levCounts[n] - 1;
        if (this.caching && this.cacheCount < 25) {
            this.cachedONodes.addElement(on);
            ++this.cacheCount;
        }
    }
}

