/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.JimiImageColorReducer;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;

public class ColorReducer {
    protected JimiImageColorReducer reducer_;
    protected boolean dither_;

    public ColorReducer(int maxColors) {
        this(maxColors, false);
    }

    public ColorReducer(int maxColors, boolean dither) {
        this.reducer_ = new JimiImageColorReducer(maxColors);
        this.dither_ = dither;
    }

    public ImageProducer getColorReducedImageProducer(ImageProducer producer) throws JimiException {
        return this.doColorReduction(producer).getImageProducer();
    }

    public ImageProducer getColorReducedImageProducer(Image image) throws JimiException {
        return this.getColorReducedImageProducer(image.getSource());
    }

    public Image getColorReducedImage(ImageProducer producer) throws JimiException {
        return Toolkit.getDefaultToolkit().createImage(this.doColorReduction(producer).getImageProducer());
    }

    public Image getColorReducedImage(Image image) throws JimiException {
        return this.getColorReducedImage(image.getSource());
    }

    protected JimiRasterImage doColorReduction(ImageProducer producer) throws JimiException {
        if (this.dither_) {
            return this.reducer_.colorReduceFS(producer);
        }
        return this.reducer_.colorReduce(producer);
    }
}

