/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.InverseColorMap;
import java.util.Random;

public class FSDither {
    static final int FS_SCALE = 1024;
    int[] thisRerr_;
    int[] nextRerr_;
    int[] thisGerr_;
    int[] nextGerr_;
    int[] thisBerr_;
    int[] nextBerr_;
    boolean forward_;
    static final int MAXVAL = 255;
    byte[] rgbCMap_;
    int numColors_;
    int width_;
    InverseColorMap invCM_;

    FSDither(byte[] rgbCMap, int numColors, int width) {
        this.rgbCMap_ = rgbCMap;
        this.numColors_ = numColors;
        this.width_ = width;
        this.invCM_ = new InverseColorMap(this.rgbCMap_);
        this.init();
    }

    void init() {
        this.thisRerr_ = new int[this.width_ + 2];
        this.nextRerr_ = new int[this.width_ + 2];
        this.thisGerr_ = new int[this.width_ + 2];
        this.nextGerr_ = new int[this.width_ + 2];
        this.thisBerr_ = new int[this.width_ + 2];
        this.nextBerr_ = new int[this.width_ + 2];
        Random r = new Random();
        for (int col = 0; col < this.width_ + 2; ++col) {
            this.thisRerr_[col] = Math.abs(r.nextInt()) % 2048 - 1024;
            this.thisGerr_[col] = Math.abs(r.nextInt()) % 2048 - 1024;
            this.thisBerr_[col] = Math.abs(r.nextInt()) % 2048 - 1024;
        }
        this.forward_ = true;
    }

    void ditherRow(int[] pixels, byte[] out) {
        int limitcol;
        int o;
        int col = this.nextRerr_.length;
        while (--col >= 0) {
            this.nextRerr_[col] = 0;
        }
        System.arraycopy(this.nextRerr_, 0, this.nextGerr_, 0, this.nextRerr_.length);
        System.arraycopy(this.nextRerr_, 0, this.nextBerr_, 0, this.nextRerr_.length);
        if (this.forward_) {
            o = 0;
            col = 0;
            limitcol = this.width_;
        } else {
            o = this.width_ - 1;
            col = this.width_ - 1;
            limitcol = -1;
        }
        while (true) {
            long err;
            int p;
            if (((p = pixels[col]) & 0xFF000000) == 0) {
                if (this.forward_) {
                    out[o++] = (byte)this.numColors_;
                    if (++col < limitcol) continue;
                    break;
                }
                out[o--] = (byte)this.numColors_;
                if (--col > limitcol) continue;
                break;
            }
            int sr = (p & 0xFF0000) >> 16;
            int sg = (p & 0xFF00) >> 8;
            int sb = p & 0xFF;
            sr = ((p & 0xFF0000) >> 16) + this.thisRerr_[col + 1] / 1024;
            sg = ((p & 0xFF00) >> 8) + this.thisGerr_[col + 1] / 1024;
            sb = (p & 0xFF) + this.thisBerr_[col + 1] / 1024;
            if (sr < 0) {
                sr = 0;
            } else if (sr > 255) {
                sr = 255;
            }
            if (sg < 0) {
                sg = 0;
            } else if (sg > 255) {
                sg = 255;
            }
            if (sb < 0) {
                sb = 0;
            } else if (sb > 255) {
                sb = 255;
            }
            int idx = this.invCM_.getIndexNearest(sr, sg, sb);
            int sr2 = this.rgbCMap_[idx * 4] & 0xFF;
            int sg2 = this.rgbCMap_[idx * 4 + 1] & 0xFF;
            int sb2 = this.rgbCMap_[idx * 4 + 2] & 0xFF;
            if (this.forward_) {
                out[o++] = (byte)idx;
                err = (long)(sr - sr2) * 1024L;
                int n = col + 2;
                this.thisRerr_[n] = (int)((long)this.thisRerr_[n] + err * 7L / 16L);
                int n2 = col;
                this.nextRerr_[n2] = (int)((long)this.nextRerr_[n2] + err * 3L / 16L);
                int n3 = col + 1;
                this.nextRerr_[n3] = (int)((long)this.nextRerr_[n3] + err * 5L / 16L);
                int n4 = col + 2;
                this.nextRerr_[n4] = (int)((long)this.nextRerr_[n4] + err / 16L);
                err = (long)(sg - sg2) * 1024L;
                int n5 = col + 2;
                this.thisGerr_[n5] = (int)((long)this.thisGerr_[n5] + err * 7L / 16L);
                int n6 = col;
                this.nextGerr_[n6] = (int)((long)this.nextGerr_[n6] + err * 3L / 16L);
                int n7 = col + 1;
                this.nextGerr_[n7] = (int)((long)this.nextGerr_[n7] + err * 5L / 16L);
                int n8 = col + 2;
                this.nextGerr_[n8] = (int)((long)this.nextGerr_[n8] + err / 16L);
                err = (long)(sb - sb2) * 1024L;
                int n9 = col + 2;
                this.thisBerr_[n9] = (int)((long)this.thisBerr_[n9] + err * 7L / 16L);
                int n10 = col;
                this.nextBerr_[n10] = (int)((long)this.nextBerr_[n10] + err * 3L / 16L);
                int n11 = col + 1;
                this.nextBerr_[n11] = (int)((long)this.nextBerr_[n11] + err * 5L / 16L);
                int n12 = col + 2;
                this.nextBerr_[n12] = (int)((long)this.nextBerr_[n12] + err / 16L);
                if (++col < limitcol) continue;
                break;
            }
            out[o--] = (byte)idx;
            err = (long)(sr - sr2) * 1024L;
            int n = col;
            this.thisRerr_[n] = (int)((long)this.thisRerr_[n] + err * 7L / 16L);
            int n13 = col + 2;
            this.nextRerr_[n13] = (int)((long)this.nextRerr_[n13] + err * 3L / 16L);
            int n14 = col + 1;
            this.nextRerr_[n14] = (int)((long)this.nextRerr_[n14] + err * 5L / 16L);
            int n15 = col;
            this.nextRerr_[n15] = (int)((long)this.nextRerr_[n15] + err / 16L);
            err = (long)(sg - sg2) * 1024L;
            int n16 = col;
            this.thisGerr_[n16] = (int)((long)this.thisGerr_[n16] + err * 7L / 16L);
            int n17 = col + 2;
            this.nextGerr_[n17] = (int)((long)this.nextGerr_[n17] + err * 3L / 16L);
            int n18 = col + 1;
            this.nextGerr_[n18] = (int)((long)this.nextGerr_[n18] + err * 5L / 16L);
            int n19 = col;
            this.nextGerr_[n19] = (int)((long)this.nextGerr_[n19] + err / 16L);
            err = (long)(sb - sb2) * 1024L;
            int n20 = col;
            this.thisBerr_[n20] = (int)((long)this.thisBerr_[n20] + err * 7L / 16L);
            int n21 = col + 2;
            this.nextBerr_[n21] = (int)((long)this.nextBerr_[n21] + err * 3L / 16L);
            int n22 = col + 1;
            this.nextBerr_[n22] = (int)((long)this.nextBerr_[n22] + err * 5L / 16L);
            int n23 = col--;
            this.nextBerr_[n23] = (int)((long)this.nextBerr_[n23] + err / 16L);
            if (col <= limitcol) break;
        }
        int[] temperr = this.thisRerr_;
        this.thisRerr_ = this.nextRerr_;
        this.nextRerr_ = temperr;
        temperr = this.thisGerr_;
        this.thisGerr_ = this.nextGerr_;
        this.nextGerr_ = temperr;
        temperr = this.thisBerr_;
        this.thisBerr_ = this.nextBerr_;
        this.nextBerr_ = temperr;
        this.forward_ = !this.forward_;
    }

    int findIdx(int sr, int sg, int sb) throws ArrayIndexOutOfBoundsException {
        int idx = 0;
        long dist = 2000000000L;
        int i = this.numColors_;
        while (--i >= 0) {
            int r2 = this.rgbCMap_[i * 4] & 0xFF;
            int g2 = this.rgbCMap_[i * 4 + 1] & 0xFF;
            int b2 = this.rgbCMap_[i * 4 + 2] & 0xFF;
            long newdist = (sr - r2) * (sr - r2) + (sg - g2) * (sg - g2) + (sb - b2) * (sb - b2);
            if (newdist >= dist) continue;
            idx = i;
            dist = newdist;
        }
        return idx;
    }
}

