/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ColorModel;

public class GrayscaleColorModel
extends ColorModel {
    boolean zeroIsWhite;
    int maxVal;
    int pixelMask;

    public GrayscaleColorModel(boolean zeroIsWhite) {
        super(8);
        this.init(zeroIsWhite);
    }

    public GrayscaleColorModel(boolean zeroIsWhite, int pixelSize) {
        super(pixelSize);
        this.init(zeroIsWhite);
    }

    public boolean getZeroIsWhite() {
        return this.zeroIsWhite;
    }

    protected void init(boolean zeroIsWhite) {
        this.zeroIsWhite = zeroIsWhite;
        this.maxVal = (int)Math.pow(2.0, this.getPixelSize());
        --this.maxVal;
        this.pixelMask = 255 >> 8 - this.getPixelSize();
    }

    public int getRed(int pixel) {
        pixel &= this.pixelMask;
        if (this.zeroIsWhite) {
            pixel = this.maxVal - pixel;
        }
        pixel = pixel * 255 / this.maxVal;
        return pixel;
    }

    public int getGreen(int pixel) {
        pixel &= this.pixelMask;
        if (this.zeroIsWhite) {
            pixel = this.maxVal - pixel;
        }
        pixel = pixel * 255 / this.maxVal;
        return pixel;
    }

    public int getBlue(int pixel) {
        pixel &= this.pixelMask;
        if (this.zeroIsWhite) {
            pixel = this.maxVal - pixel;
        }
        pixel = pixel * 255 / this.maxVal;
        return pixel;
    }

    public int getAlpha(int pixel) {
        return 255;
    }

    public int getRGB(int pixel) {
        int val = this.getAlpha(pixel) << 24 | this.getRed(pixel) << 16 | this.getGreen(pixel) << 8 | this.getBlue(pixel);
        return val;
    }
}

