/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

class InverseColorMap {
    static final int QUANTBITS = 5;
    static final int TRUNCBITS = 3;
    static final int QUANTMASK_BLUE = 31;
    static final int QUANTMASK_GREEN = 992;
    static final int QUANTMASK_RED = 31744;
    static final int MAXQUANTVAL = 32;
    byte[] rgbCMap_;
    int numColors_;
    int maxColor_;
    byte[] irgb_;

    InverseColorMap(byte[] rgbCMap) {
        this.rgbCMap_ = rgbCMap;
        this.numColors_ = this.rgbCMap_.length / 4;
        this.irgb_ = new byte[32768];
        this.initIRGB(new int[32768]);
    }

    void initIRGB(int[] tmp) {
        int x = 8;
        int xsqr = 64;
        int xsqr2 = xsqr + xsqr;
        byte[] irgb = this.irgb_;
        for (int i = 0; i < this.numColors_; ++i) {
            int red = this.rgbCMap_[i * 4] & 0xFF;
            int green = this.rgbCMap_[i * 4 + 1] & 0xFF;
            int blue = this.rgbCMap_[i * 4 + 2] & 0xFF;
            int rdist = red - x / 2;
            int gdist = green - x / 2;
            int bdist = blue - x / 2;
            rdist = rdist * rdist + gdist * gdist + bdist * bdist;
            int rinc = 2 * (xsqr - (red << 3));
            int ginc = 2 * (xsqr - (green << 3));
            int binc = 2 * (xsqr - (blue << 3));
            int rgbI = 0;
            int r = 0;
            int rxx = rinc;
            while (r < 32) {
                int g = 0;
                gdist = rdist;
                int gxx = ginc;
                while (g < 32) {
                    int b = 0;
                    bdist = gdist;
                    int bxx = binc;
                    while (b < 32) {
                        if (i == 0 || tmp[rgbI] > bdist) {
                            tmp[rgbI] = bdist;
                            irgb[rgbI] = (byte)i;
                        }
                        bdist += bxx;
                        ++b;
                        ++rgbI;
                        bxx += xsqr2;
                    }
                    gdist += gxx;
                    ++g;
                    gxx += xsqr2;
                }
                rdist += rxx;
                ++r;
                rxx += xsqr2;
            }
        }
    }

    public final int getIndexNearest(int color) {
        return this.irgb_[(color >> 9 & 0x7C00) + (color >> 6 & 0x3E0) + (color >> 3 & 0x1F)] & 0xFF;
    }

    public final int getIndexNearest(int red, int green, int blue) {
        return this.irgb_[(red << 7 & 0x7C00) + (green << 2 & 0x3E0) + (blue >> 3 & 0x1F)] & 0xFF;
    }
}

