/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

public class Java2DCompat {
    public static BufferedImage createBufferedImage(JimiRasterImage ji) {
        ji.waitFinished();
        DataBufferInt db = null;
        SinglePixelPackedSampleModel sm = null;
        if (ji instanceof ByteRasterImage) {
            return null;
        }
        if (ji instanceof IntRasterImage) {
            IntRasterImage ii = (IntRasterImage)ji;
            int[] pixels = ii.asIntArray();
            if (pixels == null) {
                return null;
            }
            if (!(ii.getColorModel() instanceof DirectColorModel)) {
                return null;
            }
            DirectColorModel dcm = (DirectColorModel)ii.getColorModel();
            int[] masks = new int[dcm.getNumComponents()];
            boolean alpha = false;
            switch (dcm.getNumComponents()) {
                case 4: {
                    masks[3] = dcm.getAlphaMask();
                    alpha = true;
                }
                case 3: {
                    masks[0] = dcm.getRedMask();
                    masks[1] = dcm.getGreenMask();
                    masks[2] = dcm.getBlueMask();
                }
            }
            db = new DataBufferInt(pixels, pixels.length);
            sm = new SinglePixelPackedSampleModel(3, ji.getWidth(), ji.getHeight(), masks);
            BufferedImage image = new BufferedImage(ji.getWidth(), ji.getHeight(), alpha ? 2 : 1);
            image.setData(Raster.createRaster(sm, db, new Point(0, 0)));
            return image;
        }
        return null;
    }
}

