/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.ColorOctree;
import com.sun.jimi.core.util.FSDither;
import com.sun.jimi.core.util.InverseColorMap;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

public class JimiImageColorReducer {
    ColorOctree octree;
    int maxColors;
    byte[] rgbCMap;
    int numColors;

    public JimiImageColorReducer(int maxColors) {
        this.maxColors = maxColors;
        this.octree = new ColorOctree(maxColors);
    }

    public JimiImageColorReducer(byte[] cmap, int numColors) {
        this.rgbCMap = cmap;
        this.numColors = numColors;
    }

    public JimiImageColorReducer(IndexColorModel palette) {
        this(palette, palette.getMapSize());
    }

    public JimiImageColorReducer(IndexColorModel palette, int maxColors) {
        this.maxColors = maxColors;
        byte[] map = new byte[palette.getMapSize() * 4];
        this.numColors = palette.getMapSize();
        byte[] r = new byte[palette.getMapSize()];
        byte[] g = new byte[palette.getMapSize()];
        byte[] b = new byte[palette.getMapSize()];
        byte[] a = new byte[palette.getMapSize()];
        palette.getReds(r);
        palette.getGreens(g);
        palette.getBlues(b);
        palette.getAlphas(a);
        int index = 0;
        for (int i = 0; i < r.length; ++i) {
            map[index++] = r[i];
            map[index++] = g[i];
            map[index++] = b[i];
            map[index++] = a[i];
        }
        this.rgbCMap = map;
    }

    public JimiRasterImage colorReduce(ImageProducer prod) throws JimiException {
        return this.colorReduce(Jimi.createRasterImage(prod));
    }

    public JimiRasterImage colorReduce(JimiRasterImage jiInput) throws JimiException {
        ByteRasterImage ji;
        jiInput.waitFinished();
        ColorModel cm = jiInput.getColorModel();
        if (cm instanceof IndexColorModel && ((IndexColorModel)cm).getMapSize() <= this.maxColors) {
            return jiInput;
        }
        if (this.octree != null) {
            this.fillOctree(jiInput);
            byte[] colorMap = new byte[this.maxColors * 4];
            int numColors = this.octree.getPalette(colorMap);
            ji = new MemoryJimiImageFactory().createByteRasterImage(jiInput.getWidth(), jiInput.getHeight(), new IndexColorModel(8, colorMap.length / 4, colorMap, 0, true));
            this.fillJimiRasterImage(colorMap, numColors, ji, jiInput);
        } else {
            ji = new MemoryJimiImageFactory().createByteRasterImage(jiInput.getWidth(), jiInput.getHeight(), new IndexColorModel(8, this.numColors, this.rgbCMap, 0, false));
            this.fillJimiRasterImage(this.rgbCMap, this.numColors, ji, jiInput);
        }
        return ji;
    }

    public JimiRasterImage colorReduceFS(ImageProducer prod) throws JimiException {
        return this.colorReduceFS(Jimi.createRasterImage(prod));
    }

    public JimiRasterImage colorReduceFS(JimiRasterImage jiInput) throws JimiException {
        ByteRasterImage ji;
        jiInput.waitFinished();
        ColorModel cm = jiInput.getColorModel();
        if (cm instanceof IndexColorModel && ((IndexColorModel)cm).getMapSize() <= this.maxColors) {
            return jiInput;
        }
        if (this.octree != null) {
            this.fillOctree(jiInput);
            byte[] colorMap = new byte[this.maxColors * 4];
            int numColors = this.octree.getPalette(colorMap);
            if (this.octree.hasAlpha()) {
                --numColors;
            }
            ji = new MemoryJimiImageFactory().createByteRasterImage(jiInput.getWidth(), jiInput.getHeight(), new IndexColorModel(8, this.maxColors, colorMap, 0, true));
            this.fillJimiRasterImageFS(colorMap, numColors, ji, jiInput);
        } else {
            ji = new MemoryJimiImageFactory().createByteRasterImage(jiInput.getWidth(), jiInput.getHeight(), new IndexColorModel(8, this.maxColors, this.rgbCMap, 0, false));
            this.fillJimiRasterImageFS(this.rgbCMap, this.numColors, ji, jiInput);
        }
        return ji;
    }

    private void fillJimiRasterImage(byte[] cmap, int numCMap, ByteRasterImage ji, JimiRasterImage jiIn) throws JimiException {
        int[] rowBuf = new int[jiIn.getWidth()];
        InverseColorMap invCM = new InverseColorMap(cmap);
        byte[] buf = new byte[jiIn.getWidth()];
        for (int row = 0; row < jiIn.getHeight(); ++row) {
            jiIn.getRowRGB(row, rowBuf, 0);
            for (int col = 0; col < ji.getWidth(); ++col) {
                int qIdx;
                if (this.octree != null) {
                    qIdx = this.octree.quantizeColor(rowBuf[col]);
                    buf[col] = (byte)(qIdx / 3);
                    continue;
                }
                qIdx = invCM.getIndexNearest(rowBuf[col]);
                buf[col] = (byte)qIdx;
            }
            ji.setRow(row, buf, 0);
        }
        ji.setFinished();
    }

    int findIdx(byte[] cmap, int len, int p) {
        int sr = (p & 0xFF0000) >> 16;
        int sg = (p & 0xFF00) >> 8;
        int sb = p & 0xFF;
        int idx = 0;
        long dist = 2000000000L;
        int i = len;
        while (--i >= 0) {
            int r2 = cmap[i * 3] & 0xFF;
            int g2 = cmap[i * 3 + 1] & 0xFF;
            int b2 = cmap[i * 3 + 2] & 0xFF;
            long newdist = (sr - r2) * (sr - r2) + (sg - g2) * (sg - g2) + (sb - b2) * (sb - b2);
            if (newdist >= dist) continue;
            idx = i;
            dist = newdist;
        }
        return idx;
    }

    private void fillJimiRasterImageFS(byte[] cmap, int numCMap, ByteRasterImage ji, JimiRasterImage jiIn) throws JimiException {
        int[] rowBuf = new int[jiIn.getWidth()];
        FSDither fsd = new FSDither(cmap, numCMap, jiIn.getWidth());
        byte[] buf = new byte[jiIn.getWidth()];
        for (int row = 0; row < jiIn.getHeight(); ++row) {
            jiIn.getRowRGB(row, rowBuf, 0);
            fsd.ditherRow(rowBuf, buf);
            ji.setRow(row, buf, 0);
        }
        ji.setFinished();
    }

    private void fillOctree(JimiRasterImage ji) throws JimiException {
        int[] rowBuf = new int[ji.getWidth()];
        for (int row = 0; row < ji.getHeight(); ++row) {
            ji.getRowRGB(row, rowBuf, 0);
            this.octree.addColor(rowBuf);
        }
    }
}

