/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.util.ObjectInputToStreamAdapter;
import com.sun.jimi.util.ObjectOutputToStreamAdapter;
import java.awt.Canvas;
import java.awt.Image;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class JimiImageSerializer
implements Externalizable {
    private static final long serialVersionUID = -3284218653375208081L;
    protected static final String DEFAULT_ENCODING = "image/png";
    private String encodingFormat_ = "image/png";
    protected transient Image image_;

    public JimiImageSerializer() {
    }

    public JimiImageSerializer(Image image) {
        this(image, DEFAULT_ENCODING);
    }

    private JimiImageSerializer(Image image, String encodingFormat) {
        this.image_ = image;
        this.encodingFormat_ = encodingFormat;
    }

    public Image getImage() {
        return this.image_;
    }

    public void setImage(Image image) {
        this.image_ = image;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ObjectOutputToStreamAdapter out_stream = new ObjectOutputToStreamAdapter(out);
        out.writeObject(this.encodingFormat_);
        try {
            Jimi.putImage(this.encodingFormat_, this.image_, (OutputStream)out_stream);
        }
        catch (JimiException je) {
            throw new IOException("Unable to write image: " + je.getMessage());
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.encodingFormat_ = (String)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        ObjectInputToStreamAdapter in_stream = new ObjectInputToStreamAdapter(in);
        this.image_ = Jimi.getImage((InputStream)in_stream, this.encodingFormat_);
        GraphicsUtils.waitForImage(new Canvas(), this.image_);
    }
}

