/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.JimiLicenseInformation;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.ErrorImageProducer;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class JimiUtil {
    private static final String nonFileName = "X#jimi#X";
    public static final boolean TRUE = true;
    static byte[] expansionTable;
    static int[] intExpansionTable;

    public static boolean isRGBDefault(ColorModel cm) {
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            DirectColorModel rgbDefault = (DirectColorModel)ColorModel.getRGBdefault();
            int defAMask = rgbDefault.getAlphaMask();
            int defRMask = rgbDefault.getRedMask();
            int defGMask = rgbDefault.getGreenMask();
            int defBMask = rgbDefault.getBlueMask();
            int dcmAMask = dcm.getAlphaMask();
            int dcmRMask = dcm.getRedMask();
            int dcmGMask = dcm.getGreenMask();
            int dcmBMask = dcm.getBlueMask();
            return defAMask == dcmAMask && defRMask == dcmRMask && defGMask == dcmGMask && defBMask == dcmBMask;
        }
        return false;
    }

    public static byte[] getChannelWidths(ColorModel cm) {
        byte[] widths = new byte[8];
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            widths[0] = JimiUtil.countBitsSet(dcm.getAlphaMask());
            widths[1] = JimiUtil.countBitsSet(dcm.getRedMask());
            widths[2] = JimiUtil.countBitsSet(dcm.getGreenMask());
            widths[3] = JimiUtil.countBitsSet(dcm.getBlueMask());
        } else if (cm instanceof IndexColorModel) {
            widths[0] = 8;
            widths[1] = 8;
            widths[2] = 8;
            widths[3] = 8;
        }
        return widths;
    }

    public static byte countBitsSet(int val) {
        byte count = 0;
        int mask = 1;
        for (int i = 0; i < 32; ++i) {
            if ((val & mask) != 0) {
                count = (byte)(count + 1);
            }
            mask <<= 1;
        }
        return count;
    }

    public static Image getErrorImage() {
        return Toolkit.getDefaultToolkit().createImage(JimiUtil.getErrorImageProducer());
    }

    public static ImageProducer getErrorImageProducer() {
        return new ErrorImageProducer();
    }

    public static void expandPixels(int bitSize, byte[] in, byte[] out, int outLen) {
        if (bitSize == 1) {
            JimiUtil.expandOneBitPixels(in, out, outLen);
            return;
        }
        int count = 0;
        int maskshift = 1;
        int pixelshift = 0;
        int tpixelshift = 0;
        int pixelshiftdelta = 0;
        int mask = 0;
        switch (bitSize) {
            case 1: {
                mask = 128;
                maskshift = 1;
                count = 8;
                pixelshift = 7;
                pixelshiftdelta = 1;
                break;
            }
            case 2: {
                mask = 192;
                maskshift = 2;
                count = 4;
                pixelshift = 6;
                pixelshiftdelta = 2;
                break;
            }
            case 4: {
                mask = 240;
                maskshift = 4;
                count = 2;
                pixelshift = 4;
                pixelshiftdelta = 4;
                break;
            }
            default: {
                throw new RuntimeException("support only expand for 1, 2, 4");
            }
        }
        int i = 0;
        int o = 0;
        while (o < out.length) {
            int tmask = mask;
            tpixelshift = pixelshift;
            byte v = in[i];
            for (int t = 0; t < count && o < out.length; ++t, ++o) {
                out[o] = (byte)((v & tmask) >>> tpixelshift & 0xFF);
                tmask = (byte)((tmask & 0xFF) >>> maskshift);
                tpixelshift -= pixelshiftdelta;
            }
            ++i;
        }
    }

    public static void expandOneBitPixels(byte[] input, byte[] output, int count, int inputOffset, int outputOffset) {
        int leadingBits = inputOffset % 8;
        inputOffset /= 8;
        if (leadingBits != 0) {
            leadingBits = 8 - leadingBits;
            System.arraycopy(expansionTable, ((input[inputOffset++] & 0xFF) << 3) + 8 - leadingBits, output, outputOffset, leadingBits);
            outputOffset += leadingBits;
        }
        int remainder = count % 8;
        int max = inputOffset + count / 8;
        for (int i = inputOffset; i < max; ++i) {
            System.arraycopy(expansionTable, (input[i] & 0xFF) << 3, output, outputOffset, 8);
            outputOffset += 8;
        }
        if (remainder != 0) {
            System.arraycopy(expansionTable, (input[max - 1] & 0xFF) << 3, output, outputOffset, remainder);
        }
    }

    public static void expandOneBitPixelsToBW(byte[] input, int[] output, int count, int inputOffset, int outputOffset) {
        int leadingBits = inputOffset % 8;
        inputOffset /= 8;
        if (leadingBits != 0) {
            leadingBits = 8 - leadingBits;
            System.arraycopy(intExpansionTable, (input[inputOffset++] << 3) + 8 - leadingBits, output, outputOffset, leadingBits);
            outputOffset += leadingBits;
        }
        int remainder = count % 8;
        int max = inputOffset + count / 8;
        for (int i = inputOffset; i < max; ++i) {
            System.arraycopy(intExpansionTable, (input[i] & 0xFF) << 3, output, outputOffset, 8);
            outputOffset += 8;
        }
        if (remainder != 0) {
            System.arraycopy(intExpansionTable, (input[max] & 0xFF) << 3, output, outputOffset, remainder);
        }
    }

    public static void expandOneBitPixels(byte[] input, byte[] output, int count) {
        int remainder = count % 8;
        int max = count / 8;
        for (int i = 0; i < max; ++i) {
            int lookup = (input[i] & 0xFF) * 8;
            System.arraycopy(expansionTable, lookup, output, i * 8, 8);
        }
        if (remainder != 0) {
            System.arraycopy(expansionTable, (input[max] & 0xFF) * 8, output, max * 8, remainder);
        }
    }

    public static void packOneBitPixels(byte[] in, int inByte, byte[] out, int base, int outPixel, int len) {
        int leading_bits;
        int src_index = inByte;
        base += outPixel / 8;
        int count = (outPixel %= 8) == 0 ? len / 8 : (len - (8 - outPixel)) / 8;
        int work = 0;
        int start_idx = outPixel == 0 ? 0 : 1;
        int dest_index = base + (outPixel == 0 ? 0 : 1);
        int n = leading_bits = len < 8 - outPixel ? len : 8 - outPixel;
        if (outPixel != 0) {
            int first_pixel = 7 - outPixel;
            for (int i = 0; i < leading_bits; ++i) {
                if (in[src_index++] == 0) {
                    int n2 = base;
                    out[n2] = (byte)(out[n2] & ~(1 << first_pixel - i));
                    continue;
                }
                int n3 = base;
                out[n3] = (byte)(out[n3] | 1 << first_pixel - i);
            }
        }
        for (int i = start_idx; i < count; ++i) {
            work = 0;
            if (in[src_index++] != 0) {
                work += 128;
            }
            if (in[src_index++] != 0) {
                work += 64;
            }
            if (in[src_index++] != 0) {
                work += 32;
            }
            if (in[src_index++] != 0) {
                work += 16;
            }
            if (in[src_index++] != 0) {
                work += 8;
            }
            if (in[src_index++] != 0) {
                work += 4;
            }
            if (in[src_index++] != 0) {
                work += 2;
            }
            if (in[src_index++] != 0) {
                ++work;
            }
            out[dest_index + i] = (byte)work;
        }
        int remainder = outPixel == 0 ? len % 8 : len - (8 - outPixel) % 8;
        int last_index = base + count;
        if ((remainder %= 8) > 0) {
            for (int i = 0; i < remainder; ++i) {
                if (in[src_index++] == 0) {
                    int n4 = last_index;
                    out[n4] = (byte)(out[n4] & ~(1 << 7 - i));
                    continue;
                }
                int n5 = last_index;
                out[n5] = (byte)(out[n5] | 1 << 7 - i);
            }
        }
    }

    public static void packPixels(int[] in, int sindex, byte[] out, int dindex, int len) {
        int idx = sindex;
        int fullbytes = len / 8;
        for (int i = 0; i < fullbytes; ++i) {
            int code = 0;
            if (in[idx++] == -1) {
                code |= 0x80;
            }
            if (in[idx++] == -1) {
                code |= 0x40;
            }
            if (in[idx++] == -1) {
                code |= 0x20;
            }
            if (in[idx++] == -1) {
                code |= 0x10;
            }
            if (in[idx++] == -1) {
                code |= 8;
            }
            if (in[idx++] == -1) {
                code |= 4;
            }
            if (in[idx++] == -1) {
                code |= 2;
            }
            if (in[idx++] == -1) {
                code |= 1;
            }
            out[dindex + i] = (byte)code;
        }
        int remainder = len % 8;
        int ridx = 7;
        int rval = 255;
        while (remainder-- > 0) {
            if (in[idx++] == -1) continue;
            rval &= ~(1 << ridx--);
        }
        out[dindex + fullbytes] = (byte)rval;
    }

    public static int packPixels(int depth, byte[] in, byte[] out) {
        int mask = (1 << depth) - 1;
        int inLen = in.length;
        switch (depth) {
            case 1: {
                int rem = inLen % 8;
                int end = inLen / 8;
                int retVal = end + 1;
                int endIdx = inLen;
                int val = 0;
                switch (rem) {
                    case 7: {
                        val |= (in[--endIdx] & mask) << 1;
                    }
                    case 6: {
                        val |= (in[--endIdx] & mask) << 2;
                    }
                    case 5: {
                        val |= (in[--endIdx] & mask) << 3;
                    }
                    case 4: {
                        val |= (in[--endIdx] & mask) << 4;
                    }
                    case 3: {
                        val |= (in[--endIdx] & mask) << 5;
                    }
                    case 2: {
                        val |= (in[--endIdx] & mask) << 6;
                    }
                    case 1: {
                        out[end] = (byte)(val |= (in[--endIdx] & mask) << 7);
                        break;
                    }
                    case 0: {
                        --retVal;
                    }
                }
                endIdx = inLen - rem;
                int outIdx = end;
                while (--outIdx >= 0) {
                    out[outIdx] = (byte)(in[--endIdx] & mask | (in[--endIdx] & mask) << 1 | (in[--endIdx] & mask) << 2 | (in[--endIdx] & mask) << 3 | (in[--endIdx] & mask) << 4 | (in[--endIdx] & mask) << 5 | (in[--endIdx] & mask) << 6 | (in[--endIdx] & mask) << 7);
                }
                return retVal;
            }
            case 2: {
                int rem = inLen % 4;
                int end = inLen / 4;
                int retVal = end + 1;
                int endIdx = inLen;
                int val = 0;
                switch (rem) {
                    case 3: {
                        val |= (in[--endIdx] & mask) << 2;
                    }
                    case 2: {
                        val |= (in[--endIdx] & mask) << 4;
                    }
                    case 1: {
                        out[end] = (byte)(val |= (in[--endIdx] & mask) << 6);
                        break;
                    }
                    case 0: {
                        --retVal;
                    }
                }
                endIdx = inLen - rem;
                int outIdx = end;
                while (--outIdx >= 0) {
                    out[outIdx] = (byte)(in[--endIdx] & mask | (in[--endIdx] & mask) << 2 | (in[--endIdx] & mask) << 4 | (in[--endIdx] & mask) << 6);
                }
                return retVal;
            }
            case 4: {
                int rem = inLen % 2;
                int end = inLen / 2;
                int retVal = end + 1;
                int endIdx = inLen;
                int val = 0;
                switch (rem) {
                    case 1: {
                        out[end] = (byte)(val |= (in[--endIdx] & mask) << 4);
                        break;
                    }
                    case 0: {
                        --retVal;
                    }
                }
                endIdx = inLen - rem;
                int outIdx = end;
                while (--outIdx >= 0) {
                    out[outIdx] = (byte)(in[--endIdx] & mask | (in[--endIdx] & mask) << 4);
                }
                return retVal;
            }
            case 8: {
                System.arraycopy(in, 0, out, 0, inLen);
                return inLen;
            }
        }
        throw new IllegalArgumentException("depth must be 1 2 4 or 8, not " + depth);
    }

    public static void pixelDepthChange(int depth, byte[] buf, int newDepth) {
        if (newDepth <= depth) {
            throw new IllegalArgumentException("pixelDepth Must < newPixelSize");
        }
        int pixelShift = newDepth - depth;
        int newDepthVal = (1 << newDepth) - 1;
        int oldDepthVal = (1 << depth) - 1;
        int i = buf.length;
        while (--i >= 0) {
            buf[i] = (byte)(buf[i] * newDepthVal / oldDepthVal);
        }
    }

    public static JimiRasterImage asJimiRasterImage(JimiImage ji) {
        if (ji instanceof JimiRasterImage) {
            return (JimiRasterImage)ji;
        }
        if (ji instanceof JimiImageHandle) {
            try {
                return JimiUtil.asJimiRasterImage(((JimiImageHandle)ji).getWrappedJimiImage());
            }
            catch (JimiException je) {
                return null;
            }
        }
        return null;
    }

    public static boolean flagSet(int flaggedValue, int flag) {
        return (flaggedValue & flag) != 0;
    }

    public static boolean flagsSet(int flaggedValue, int flags) {
        return (flaggedValue & flags) == flags;
    }

    public static JimiImageFactory stripStamping(JimiImageFactory imageFactory) {
        if (JimiLicenseInformation.isCrippled()) {
            return imageFactory;
        }
        JimiImageFactory realFactory = imageFactory;
        while (realFactory instanceof JimiImageFactoryProxy) {
            realFactory = ((JimiImageFactoryProxy)realFactory).getProxiedFactory();
        }
        if (realFactory instanceof MemoryJimiImageFactory || realFactory.getClass().getName().equals("com.sun.jimi.core.VMemStampedJimiImageFactory")) {
            imageFactory = realFactory;
        }
        return imageFactory;
    }

    public static boolean isCompatibleWithJavaVersion(int major, int minor) {
        try {
            String version = System.getProperty("java.version");
            int vmMajor = Integer.parseInt(version.substring(0, version.indexOf(46)));
            String minorString = version.substring(version.indexOf(".") + 1);
            if (minorString.indexOf(46) != -1) {
                minorString = minorString.substring(0, minorString.indexOf(46));
            }
            int vmMinor = Integer.parseInt(minorString);
            boolean result = vmMajor > major || vmMajor == major && vmMinor >= minor;
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void runCommands(Vector commands) {
        Enumeration enumeration = commands.elements();
        while (enumeration.hasMoreElements()) {
            ((Runnable)enumeration.nextElement()).run();
        }
    }

    static {
        int i;
        expansionTable = new byte[2048];
        intExpansionTable = new int[2048];
        int index = 0;
        for (i = 0; i < 256; ++i) {
            JimiUtil.expansionTable[index++] = (i & 0x80) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 0x40) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 0x20) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 0x10) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 8) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 4) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 2) == 0 ? (byte)0 : 1;
            JimiUtil.expansionTable[index++] = (i & 1) == 0 ? (byte)0 : 1;
        }
        index = 0;
        for (i = 0; i < 256; ++i) {
            JimiUtil.intExpansionTable[index++] = (i & 0x80) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 0x40) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 0x20) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 0x10) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 8) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 4) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 2) == 0 ? -16777216 : -1;
            JimiUtil.intExpansionTable[index++] = (i & 1) == 0 ? -16777216 : -1;
        }
    }
}

