/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public LEDataOutputStream(OutputStream out) {
        super(out);
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += len;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        ++this.written;
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        ++this.written;
    }

    public final void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeChar(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeInt(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 24 & 0xFF);
        this.written += 4;
    }

    public final void writeLong(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0) & 0xFF);
        out.write((int)(v >>> 8) & 0xFF);
        out.write((int)(v >>> 16) & 0xFF);
        out.write((int)(v >>> 24) & 0xFF);
        out.write((int)(v >>> 32) & 0xFF);
        out.write((int)(v >>> 40) & 0xFF);
        out.write((int)(v >>> 48) & 0xFF);
        out.write((int)(v >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            out.write((byte)s.charAt(i));
        }
        this.written += len;
    }

    public final void writeChars(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
        }
        this.written += len * 2;
    }

    public final void writeUTF(String str) throws IOException {
    }

    public final int size() {
        return this.written;
    }
}

