/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.util.Hashtable;
import java.util.Vector;

public class MulticastImageConsumer
implements ImageConsumer {
    protected int hints_;
    protected ColorModel colorModel_;
    protected int width_;
    protected int height_;
    protected Hashtable properties_;
    private Vector consumers_ = new Vector();
    private ImageConsumer[] consumerCache_;
    private boolean cacheValid_ = false;

    public void setDimensions(int w, int h) {
        this.width_ = w;
        this.height_ = h;
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setDimensions(w, h);
        }
    }

    public void setColorModel(ColorModel cm) {
        this.colorModel_ = cm;
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setColorModel(cm);
        }
    }

    public void setHints(int hints) {
        this.hints_ = hints;
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setHints(hints);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }

    public void imageComplete(int status) {
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].imageComplete(status);
        }
    }

    public void setProperties(Hashtable properties) {
        this.properties_ = properties;
        ImageConsumer[] consumers = this.getConsumers();
        for (int i = 0; i < consumers.length; ++i) {
            consumers[i].setProperties(properties);
        }
    }

    public synchronized ImageConsumer[] getConsumers() {
        if (!this.cacheValid_) {
            this.consumerCache_ = new ImageConsumer[this.consumers_.size()];
            this.consumers_.copyInto(this.consumerCache_);
            this.cacheValid_ = true;
        }
        return this.consumerCache_;
    }

    public synchronized void addConsumer(ImageConsumer consumer) {
        this.cacheValid_ = false;
        this.consumers_.addElement(consumer);
    }

    public void addConsumers(ImageConsumer[] consumers) {
        this.consumers_.ensureCapacity(this.consumers_.size() + consumers.length);
        for (int i = 0; i < consumers.length; ++i) {
            this.addConsumer(consumers[i]);
        }
    }

    public void removeConsumer(ImageConsumer consumer) {
        this.cacheValid_ = false;
        this.consumers_.removeElement(consumer);
    }

    public void removeAll() {
        this.cacheValid_ = false;
        this.consumers_.removeAllElements();
    }

    public boolean isEmpty() {
        return this.consumers_.size() == 0;
    }

    public boolean contains(ImageConsumer consumer) {
        return this.consumers_.contains(consumer);
    }
}

