/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ColorModel;

public class NewDirectColorModel
extends ColorModel {
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_offset;
    private int green_offset;
    private int blue_offset;
    private int alpha_offset;
    private int red_scale;
    private int green_scale;
    private int blue_scale;
    private int alpha_scale;
    private int accum_mask = 0;

    public NewDirectColorModel(int bits, int rmask, int gmask, int bmask) {
        this(bits, rmask, gmask, bmask, 0);
    }

    public NewDirectColorModel(int bits, int rmask, int gmask, int bmask, int amask) {
        super(bits);
        this.red_mask = rmask;
        this.green_mask = gmask;
        this.blue_mask = bmask;
        this.alpha_mask = amask;
        this.CalculateOffsets();
    }

    public final int getRedMask() {
        return this.red_mask;
    }

    public final int getGreenMask() {
        return this.green_mask;
    }

    public final int getBlueMask() {
        return this.blue_mask;
    }

    public final int getAlphaMask() {
        return this.alpha_mask;
    }

    private void DecomposeMask(int mask, String componentName, int[] values) {
        int scale;
        if ((mask & this.accum_mask) != 0) {
            throw new IllegalArgumentException(componentName + " mask bits not unique");
        }
        int off = 0;
        int count = 0;
        if (mask != 0) {
            while ((mask & 1) == 0) {
                mask >>>= 1;
                ++off;
            }
            while ((mask & 1) == 1) {
                mask >>>= 1;
                ++count;
            }
        }
        if (mask != 0) {
            throw new IllegalArgumentException(componentName + " mask bits not contiguous");
        }
        if (off + count > this.pixel_bits) {
            throw new IllegalArgumentException(componentName + " mask overflows pixel");
        }
        if (count < 8) {
            scale = (1 << count) - 1;
        } else {
            scale = 0;
            if (count > 8) {
                off += count - 8;
            }
        }
        values[0] = off;
        values[1] = scale;
    }

    private void CalculateOffsets() {
        int[] values = new int[2];
        this.DecomposeMask(this.red_mask, "red", values);
        this.red_offset = values[0];
        this.red_scale = values[1];
        this.DecomposeMask(this.green_mask, "green", values);
        this.green_offset = values[0];
        this.green_scale = values[1];
        this.DecomposeMask(this.blue_mask, "blue", values);
        this.blue_offset = values[0];
        this.blue_scale = values[1];
        this.DecomposeMask(this.alpha_mask, "alpha", values);
        this.alpha_offset = values[0];
        this.alpha_scale = values[1];
    }

    public final int getRed(int pixel) {
        int r = (pixel & this.red_mask) >>> this.red_offset;
        if (this.red_scale != 0) {
            r = r * 255 / this.red_scale;
        }
        return r;
    }

    public final int getGreen(int pixel) {
        int g = (pixel & this.green_mask) >>> this.green_offset;
        if (this.green_scale != 0) {
            g = g * 255 / this.green_scale;
        }
        return g;
    }

    public final int getBlue(int pixel) {
        int b = (pixel & this.blue_mask) >>> this.blue_offset;
        if (this.blue_scale != 0) {
            b = b * 255 / this.blue_scale;
        }
        return b;
    }

    public final int getAlpha(int pixel) {
        if (this.alpha_mask == 0) {
            return 255;
        }
        int a = (pixel & this.alpha_mask) >>> this.alpha_offset;
        if (this.alpha_scale != 0) {
            a = a * 255 / this.alpha_scale;
        }
        return a;
    }

    public final int getRGB(int pixel) {
        return this.getAlpha(pixel) << 24 | this.getRed(pixel) << 16 | this.getGreen(pixel) << 8 | this.getBlue(pixel) << 0;
    }
}

