/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.io.DataInputStream;
import java.io.IOException;

public class Packbits {
    static final int INITIAL = 0;
    static final int LITERAL = 1;
    static final int UNDECIDED = 2;
    static byte[] runb;

    public static void unpackbits(byte[] inb, int ini, byte[] outb, int outi, int len) {
    }

    public static void unpackbitsLimit(byte[] inb, int inbLen, byte[] outb) throws ArrayStoreException, ArrayIndexOutOfBoundsException {
        int i = 0;
        int o = 0;
        o = 0;
        while (o < outb.length && i != inbLen) {
            int b;
            if ((b = inb[i++]) >= 0) {
                System.arraycopy(inb, i, outb, o, ++b);
                i += b;
                o += b;
                continue;
            }
            if (b == -128) continue;
            byte rep = inb[i++];
            int end = o - b + 1;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
        while (o < outb.length) {
            outb[o++] = 0;
        }
    }

    public static void unpackbits(byte[] inb, byte[] outb) throws ArrayStoreException, ArrayIndexOutOfBoundsException {
        int i = 0;
        int o = 0;
        o = 0;
        while (o < outb.length) {
            int b;
            if ((b = inb[i++]) >= 0) {
                System.arraycopy(inb, i, outb, o, ++b);
                i += b;
                o += b;
                continue;
            }
            if (b == -128) continue;
            byte rep = inb[i++];
            int end = o - b + 1;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
    }

    public static void unpackbits(byte[] inb, int[] outb) throws ArrayStoreException, ArrayIndexOutOfBoundsException {
        int i = 0;
        int o = 0;
        o = 0;
        while (o < outb.length) {
            int end;
            int b;
            if ((b = inb[i++]) >= 0) {
                end = o + ++b;
                while (o < end) {
                    outb[o] = ((inb[i] & 0xFF) << 8) + (inb[i + 1] & 0xFF) & 0xFFFF;
                    ++o;
                    i += 2;
                }
                continue;
            }
            if (b == -128) continue;
            int rep = ((inb[i] & 0xFF) << 8) + (inb[i + 1] & 0xFF) & 0xFFFF;
            i += 2;
            end = o - b + 1;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
    }

    public static void unpackbits(DataInputStream in, byte[] outb) throws ArrayStoreException, ArrayIndexOutOfBoundsException, IOException {
        int o = 0;
        o = 0;
        while (o < outb.length) {
            int b = in.readByte();
            if (b >= 0) {
                ++b;
                for (int j = 0; j < b; ++j) {
                    outb[o + j] = in.readByte();
                }
                o += b;
                continue;
            }
            if (b == -128) continue;
            byte rep = in.readByte();
            int end = o - b + 1;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
    }

    public static int getAllRuns(byte[] inb) {
        int i = 0;
        int o = 0;
        do {
            int repLen;
            int start = i;
            byte b = inb[i++];
            while (i < inb.length && b == inb[i]) {
                ++i;
            }
            for (repLen = i - start; repLen > 128; repLen -= 128) {
                Packbits.runb[o++] = 127;
            }
            Packbits.runb[o++] = (byte)(repLen - 1);
        } while (i < inb.length);
        return o;
    }

    public static int packbits(byte[] inb, byte[] outb) throws ArrayStoreException, ArrayIndexOutOfBoundsException {
        if (runb == null || runb.length != inb.length) {
            runb = new byte[inb.length];
        }
        int runbLen = Packbits.getAllRuns(inb);
        int runcount = 0;
        int state = 0;
        int i = 0;
        int o = 0;
        block9: for (int runI = 0; runI < runbLen; ++runI) {
            switch (state) {
                case 0: {
                    int repLen;
                    for (repLen = runb[runI] + 1; repLen > 128; repLen -= 128) {
                        outb[o++] = -127;
                        outb[o++] = inb[i];
                        i += 128;
                    }
                    if (repLen == 1) {
                        state = 1;
                        runcount = 1;
                        continue block9;
                    }
                    if (repLen == 2) {
                        state = 2;
                        runcount = 2;
                        continue block9;
                    }
                    outb[o++] = (byte)(-(repLen - 1));
                    outb[o++] = inb[i];
                    i += repLen;
                    continue block9;
                }
                case 1: {
                    int repLen;
                    if (repLen < 3) {
                        runcount += repLen;
                        continue block9;
                    }
                    state = 0;
                    while (runcount > 128) {
                        outb[o++] = 127;
                        System.arraycopy(inb, i, outb, o, 128);
                        i += 128;
                        o += 128;
                        runcount -= 128;
                    }
                    outb[o++] = (byte)(runcount - 1);
                    System.arraycopy(inb, i, outb, o, runcount);
                    i += runcount;
                    o += runcount;
                    while (repLen > 128) {
                        outb[o++] = -127;
                        outb[o++] = inb[i];
                        i += 128;
                        repLen -= 128;
                    }
                    if (repLen == 1) {
                        state = 1;
                        runcount = 1;
                        continue block9;
                    }
                    if (repLen == 2) {
                        state = 2;
                        runcount = 2;
                        continue block9;
                    }
                    outb[o++] = (byte)(-(repLen - 1));
                    outb[o++] = inb[i];
                    i += repLen;
                    continue block9;
                }
                case 2: {
                    int repLen;
                    if (repLen == 1) {
                        state = 1;
                        ++runcount;
                        continue block9;
                    }
                    if (repLen == 2) {
                        runcount += 2;
                        continue block9;
                    }
                    state = 0;
                    while (runcount > 0) {
                        outb[o++] = -1;
                        outb[o++] = inb[i];
                        i += 2;
                        runcount -= 2;
                    }
                    while (repLen > 128) {
                        outb[o++] = -127;
                        outb[o++] = inb[i];
                        i += 128;
                        repLen -= 128;
                    }
                    if (repLen == 1) {
                        state = 1;
                        runcount = 1;
                        continue block9;
                    }
                    if (repLen == 2) {
                        state = 2;
                        runcount = 2;
                        continue block9;
                    }
                    outb[o++] = (byte)(-(repLen - 1));
                    outb[o++] = inb[i];
                    i += repLen;
                }
            }
        }
        switch (state) {
            case 1: {
                while (runcount > 128) {
                    outb[o++] = 127;
                    System.arraycopy(inb, i, outb, o, 128);
                    i += 128;
                    o += 128;
                    runcount -= 128;
                }
                if (runcount <= 0) break;
                outb[o++] = (byte)(runcount - 1);
                System.arraycopy(inb, i, outb, o, runcount);
                i += runcount;
                o += runcount;
                break;
            }
            case 2: {
                while (runcount > 0) {
                    outb[o++] = -1;
                    outb[o++] = inb[i];
                    i += 2;
                    runcount -= 2;
                }
                break;
            }
        }
        return o;
    }
}

