/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    ImageProducer producer;
    int dstX;
    int dstY;
    int dstW;
    int dstH;
    ColorModel imageModel;
    byte[] bytePixels;
    int[] intPixels;
    int dstOff;
    int dstScan;
    private boolean grabbing;
    private int flags;
    private final int GRABBEDBITS = 48;
    private final int DONEBITS = 112;

    public PixelGrabber(Image img, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this(img.getSource(), x, y, w, h, pix, off, scansize);
    }

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.producer = ip;
        this.dstX = x;
        this.dstY = y;
        this.dstW = w;
        this.dstH = h;
        this.dstOff = off;
        this.dstScan = scansize;
        this.intPixels = pix;
        this.imageModel = ColorModel.getRGBdefault();
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, boolean forceRGB) {
        this.producer = img.getSource();
        this.dstX = x;
        this.dstY = y;
        this.dstW = w;
        this.dstH = h;
        if (forceRGB) {
            this.imageModel = ColorModel.getRGBdefault();
        }
    }

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, boolean forceRGB) {
        this.producer = ip;
        this.dstX = x;
        this.dstY = y;
        this.dstW = w;
        this.dstH = h;
        if (forceRGB) {
            this.imageModel = ColorModel.getRGBdefault();
        }
    }

    public PixelGrabber(ImageProducer ip) {
        this.producer = ip;
        this.dstX = 0;
        this.dstY = 0;
        this.dstW = -1;
        this.dstH = -1;
    }

    public synchronized void startGrabbing() {
        if ((this.flags & 0x70) != 0) {
            return;
        }
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized boolean grabPixels(long ms) throws InterruptedException {
        if ((this.flags & 0x70) != 0) {
            return (this.flags & 0x30) != 0;
        }
        long end = ms + System.currentTimeMillis();
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
        while (this.grabbing) {
            long timeout;
            if (ms == 0L) {
                timeout = 0L;
            } else {
                timeout = end - System.currentTimeMillis();
                if (timeout <= 0L) break;
            }
            this.wait(timeout);
        }
        return (this.flags & 0x30) != 0;
    }

    public synchronized int getStatus() {
        return this.flags;
    }

    public synchronized int getWidth() {
        return this.dstW < 0 ? -1 : this.dstW;
    }

    public synchronized int getHeight() {
        return this.dstH < 0 ? -1 : this.dstH;
    }

    public synchronized Object getPixels() {
        return this.bytePixels == null ? this.intPixels : (int[])this.bytePixels;
    }

    public synchronized ColorModel getColorModel() {
        return this.imageModel;
    }

    public void setDimensions(int width, int height) {
        if (this.dstW < 0) {
            this.dstW = width - this.dstX;
        }
        if (this.dstH < 0) {
            this.dstH = height - this.dstY;
        }
        if (this.dstW <= 0 || this.dstH <= 0) {
            this.imageComplete(3);
        } else if (this.intPixels == null && this.imageModel == ColorModel.getRGBdefault()) {
            this.intPixels = new int[this.dstW * this.dstH];
            this.dstScan = this.dstW;
            this.dstOff = 0;
        }
        this.flags |= 3;
    }

    public void setHints(int hints) {
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
    }

    private void convertToRGB() {
        int size = this.dstW * this.dstH;
        int[] newpixels = new int[size];
        if (this.bytePixels != null) {
            for (int i = 0; i < size; ++i) {
                newpixels[i] = this.imageModel.getRGB(this.bytePixels[i] & 0xFF);
            }
        } else if (this.intPixels != null) {
            for (int i = 0; i < size; ++i) {
                newpixels[i] = this.imageModel.getRGB(this.intPixels[i]);
            }
        }
        this.bytePixels = null;
        this.intPixels = newpixels;
        this.dstScan = this.dstW;
        this.dstOff = 0;
        this.imageModel = ColorModel.getRGBdefault();
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, byte[] pixels, int srcOff, int srcScan) {
        int diff;
        if (srcY < this.dstY) {
            diff = this.dstY - srcY;
            if (diff >= srcH) {
                return;
            }
            srcOff += srcScan * diff;
            srcY += diff;
            srcH -= diff;
        }
        if (srcY + srcH > this.dstY + this.dstH && (srcH = this.dstY + this.dstH - srcY) <= 0) {
            return;
        }
        if (srcX < this.dstX) {
            diff = this.dstX - srcX;
            if (diff >= srcW) {
                return;
            }
            srcOff += diff;
            srcX += diff;
            srcW -= diff;
        }
        if (srcX + srcW > this.dstX + this.dstW && (srcW = this.dstX + this.dstW - srcX) <= 0) {
            return;
        }
        int dstPtr = this.dstOff + (srcY - this.dstY) * this.dstScan + (srcX - this.dstX);
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = model;
            } else if (this.imageModel != model) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                for (int h = srcH; h > 0; --h) {
                    System.arraycopy(pixels, srcOff, this.bytePixels, dstPtr, srcW);
                    srcOff += srcScan;
                    dstPtr += this.dstScan;
                }
            }
        }
        if (this.intPixels != null) {
            int dstRem = this.dstScan - srcW;
            int srcRem = srcScan - srcW;
            for (int h = srcH; h > 0; --h) {
                for (int w = srcW; w > 0; --w) {
                    this.intPixels[dstPtr++] = model.getRGB(pixels[srcOff++] & 0xFF);
                }
                srcOff += srcRem;
                dstPtr += dstRem;
            }
        }
        this.flags |= 8;
    }

    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, int[] pixels, int srcOff, int srcScan) {
        int diff;
        if (srcY < this.dstY) {
            diff = this.dstY - srcY;
            if (diff >= srcH) {
                return;
            }
            srcOff += srcScan * diff;
            srcY += diff;
            srcH -= diff;
        }
        if (srcY + srcH > this.dstY + this.dstH && (srcH = this.dstY + this.dstH - srcY) <= 0) {
            return;
        }
        if (srcX < this.dstX) {
            diff = this.dstX - srcX;
            if (diff >= srcW) {
                return;
            }
            srcOff += diff;
            srcX += diff;
            srcW -= diff;
        }
        if (srcX + srcW > this.dstX + this.dstW && (srcW = this.dstX + this.dstW - srcX) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = model;
            } else {
                this.convertToRGB();
            }
        }
        int dstPtr = this.dstOff + (srcY - this.dstY) * this.dstScan + (srcX - this.dstX);
        if (this.imageModel == model) {
            for (int h = srcH; h > 0; --h) {
                System.arraycopy(pixels, srcOff, this.intPixels, dstPtr, srcW);
                srcOff += srcScan;
                dstPtr += this.dstScan;
            }
        } else {
            if (this.imageModel != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int dstRem = this.dstScan - srcW;
            int srcRem = srcScan - srcW;
            for (int h = srcH; h > 0; --h) {
                for (int w = srcW; w > 0; --w) {
                    this.intPixels[dstPtr++] = model.getRGB(pixels[srcOff++]);
                }
                srcOff += srcRem;
                dstPtr += dstRem;
            }
        }
        this.flags |= 8;
    }

    public synchronized void imageComplete(int status) {
        this.grabbing = false;
        switch (status) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public synchronized int status() {
        return this.flags;
    }
}

