/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Vector;

public class QueuedImageProducerProxy
implements ImageProducer {
    protected Vector queuedConsumers = new Vector();
    protected ImageProducer realProducer;

    public synchronized void setImageProducer(ImageProducer producer) {
        this.realProducer = producer;
        Enumeration consumers = this.queuedConsumers.elements();
        while (consumers.hasMoreElements()) {
            this.realProducer.addConsumer((ImageConsumer)consumers.nextElement());
        }
    }

    public ImageProducer getImageProducer() {
        return this.realProducer;
    }

    public synchronized ImageConsumer[] getConsumers() {
        Object[] consumers = new ImageConsumer[this.queuedConsumers.size()];
        this.queuedConsumers.copyInto(consumers);
        return consumers;
    }

    public synchronized void addConsumer(ImageConsumer consumer) {
        if (this.realProducer == null) {
            this.queuedConsumers.addElement(consumer);
        } else {
            this.realProducer.addConsumer(consumer);
        }
    }

    public synchronized boolean isConsumer(ImageConsumer consumer) {
        if (this.realProducer == null) {
            return this.queuedConsumers.contains(consumer);
        }
        return this.realProducer.isConsumer(consumer);
    }

    public synchronized void removeConsumer(ImageConsumer consumer) {
        if (this.realProducer == null) {
            this.queuedConsumers.removeElement(consumer);
        } else {
            this.realProducer.removeConsumer(consumer);
        }
    }

    public void startProduction(ImageConsumer consumer) {
        this.addConsumer(consumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
        this.removeConsumer(consumer);
        this.addConsumer(consumer);
    }
}

