/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.ByteBuf;
import com.sun.jimi.core.util.LEDataInputStream;
import com.sun.jimi.util.ExpandableArray;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SeekInputStream
extends FilterInputStream
implements DataInput {
    InputStream in;
    int curOffset;
    ExpandableArray bufs;
    DataInput setD;
    InputStream setDIS;
    boolean be;
    boolean underlying;

    public SeekInputStream(boolean be, InputStream in, int consumed) throws IOException {
        super(in);
        this.be = be;
        this.in = in;
        this.bufs = new ExpandableArray();
        this.curOffset = consumed;
        this.setInputStream(this.curOffset);
    }

    public synchronized void seek(int pos) throws IOException {
        this.setInputStream(pos);
    }

    protected void setInputStream(int location) throws IOException {
        InputStream stream;
        this.underlying = false;
        if (location == this.curOffset) {
            stream = this.in;
            this.underlying = true;
        } else if (location > this.curOffset) {
            int buflen = location - this.curOffset;
            ByteBuf bb = new ByteBuf(this.curOffset, buflen);
            int n = SeekInputStream.readFully(this.in, bb.buf, 0, buflen);
            if (n < 0) {
                this.curOffset += -n;
                throw new IOException();
            }
            this.curOffset += n;
            this.bufs.addElement(bb);
            stream = this.in;
            this.underlying = true;
        } else {
            stream = this.getBufIS(location);
        }
        this.setD = this.be ? new DataInputStream(stream) : new LEDataInputStream(stream);
        this.setDIS = (InputStream)((Object)this.setD);
    }

    protected InputStream getBufIS(int location) throws IOException {
        for (int i = 0; i < this.bufs.size(); ++i) {
            ByteBuf bb = (ByteBuf)this.bufs.elementAt(i);
            if (location < bb.offset || location >= bb.offset + bb.buf.length) continue;
            int relative = location - bb.offset;
            return new ByteArrayInputStream(bb.buf, relative, bb.buf.length - relative);
        }
        throw new IOException("not buffered");
    }

    protected static int readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len; n += count) {
            count = is.read(b, n, len - n);
            if (count >= 0) continue;
            return -n;
        }
        return n;
    }

    public final synchronized int read() throws IOException {
        int b = this.setDIS.read();
        if (b >= 0 && this.underlying) {
            ++this.curOffset;
        }
        return b;
    }

    public final synchronized int read(byte[] b, int off, int len) throws IOException {
        int readlen = this.setDIS.read(b, off, len);
        if (readlen < 0) {
            if (!this.underlying) {
                this.setInputStream(this.curOffset);
                return 0;
            }
            return readlen;
        }
        if (this.underlying) {
            this.curOffset += readlen;
        }
        return readlen;
    }

    public void close() throws IOException {
        this.setD = null;
        this.in.close();
        this.in = null;
        this.bufs = null;
        this.curOffset = 0;
    }

    public long skip(long n) throws IOException {
        long skipcount = this.setDIS.skip(n);
        if (skipcount < 0L) {
            if (!this.underlying) {
                this.setInputStream(this.curOffset);
                return 0L;
            }
            return skipcount;
        }
        if (this.underlying) {
            this.curOffset = (int)((long)this.curOffset + skipcount);
        }
        return skipcount;
    }

    public int available() throws IOException {
        return this.setDIS.available();
    }

    public synchronized void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
    }

    public final void readFully(byte[] b) throws IOException {
        this.setD.readFully(b, 0, b.length);
        if (this.underlying) {
            this.curOffset += b.length;
        }
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.setD.readFully(b, off, len);
        if (this.underlying) {
            this.curOffset += len;
        }
    }

    public final int skipBytes(int n) throws IOException {
        int skipped = this.setD.skipBytes(n);
        if (this.underlying) {
            this.curOffset += skipped;
        }
        return skipped;
    }

    public final boolean readBoolean() throws IOException {
        if (this.underlying) {
            ++this.curOffset;
        }
        return this.setD.readBoolean();
    }

    public final byte readByte() throws IOException {
        byte b = this.setD.readByte();
        if (b >= 0) {
            ++this.curOffset;
        }
        return b;
    }

    public final int readUnsignedByte() throws IOException {
        int ret = this.setD.readUnsignedByte();
        if (ret >= 0) {
            ++this.curOffset;
        }
        return ret;
    }

    public final short readShort() throws IOException {
        short ret = this.setD.readShort();
        if (this.underlying) {
            this.curOffset += 2;
        }
        return ret;
    }

    public final int readUnsignedShort() throws IOException {
        int ret = this.setD.readUnsignedShort();
        if (ret >= 0 && this.underlying) {
            this.curOffset += 2;
        }
        return ret;
    }

    public final char readChar() throws IOException {
        char ret = this.setD.readChar();
        if (this.underlying) {
            this.curOffset += 2;
        }
        return ret;
    }

    public final int readInt() throws IOException {
        int ret = this.setD.readInt();
        if (this.underlying) {
            this.curOffset += 4;
        }
        return ret;
    }

    public final long readLong() throws IOException {
        long ret = this.setD.readLong();
        if (this.underlying) {
            this.curOffset += 8;
        }
        return ret;
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        return new String();
    }

    public final String readUTF() throws IOException {
        return this.setD.readUTF();
    }

    public final String readUTF(DataInput in) throws IOException {
        return DataInputStream.readUTF(in);
    }
}

