/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.StampImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class StampImageFilter
extends ImageFilter {
    protected int stampx;
    protected int stampy;
    protected int stampwidth;
    protected int stampheight;

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        if (x + width >= this.stampx && x < this.stampx + this.stampwidth && y + height >= this.stampy && y < this.stampy + this.stampheight) {
            int startx = Math.max(x, this.stampx);
            int endx = Math.min(x + width, this.stampx + this.stampwidth);
            int starty = Math.max(y, this.stampy);
            int endy = Math.min(y + height, this.stampy + this.stampheight);
            for (int r = starty; r < endy; ++r) {
                for (int c = startx; c < endx; ++c) {
                    pixels[offset + (r - y) * scansize + (c - x)] = StampImage.pixels[(r - this.stampy) * 46 + (c - this.stampx)];
                }
            }
        }
        super.setPixels(x, y, width, height, model, pixels, offset, scansize);
    }

    public void setDimensions(int width, int height) {
        this.stampx = Math.max(0, (width - 46) / 2);
        this.stampy = Math.max(0, (height - 30) / 2);
        this.stampwidth = Math.min(46, width);
        this.stampheight = Math.min(30, height);
        super.setDimensions(width, height);
    }
}

