/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInput {
    InputStream in_;
    int bits_;
    int bitsCount_;
    int byteCount_;
    int numBits_;
    int numBitsMask_;
    boolean blocks_;

    public BitInput(InputStream in, boolean blocks) {
        this.in_ = in;
        this.blocks_ = blocks;
        this.bits_ = 0;
        this.bitsCount_ = 0;
        this.byteCount_ = 0;
    }

    public void setNumBits(int numBits) {
        this.numBits_ = numBits;
        this.numBitsMask_ = (1 << this.numBits_) - 1;
    }

    public int read() throws IOException {
        while (this.bitsCount_ < this.numBits_) {
            int b;
            if (this.blocks_) {
                if (this.byteCount_ == 0) {
                    this.byteCount_ = this.in_.read();
                    if (this.byteCount_ == -1) {
                        throw new EOFException();
                    }
                    this.byteCount_ &= 0xFF;
                }
                --this.byteCount_;
            }
            if ((b = this.in_.read()) == -1) {
                throw new EOFException();
            }
            this.bits_ = this.blocks_ ? this.bits_ & (1 << this.bitsCount_) - 1 | (b & 0xFF) << this.bitsCount_ : this.bits_ << 8 & 0xFFFFFF00 | b & 0xFF;
            this.bitsCount_ += 8;
        }
        int code = 0;
        if (this.blocks_) {
            code = this.bits_ & this.numBitsMask_;
            this.bits_ >>>= this.numBits_;
        } else {
            code = this.bits_ >>> this.bitsCount_ - this.numBits_ & this.numBitsMask_;
        }
        this.bitsCount_ -= this.numBits_;
        return code;
    }

    public void gifFinishBlocks() throws IOException {
        if (this.blocks_) {
            while (true) {
                if (this.byteCount_ == 0) {
                    this.byteCount_ = this.in_.read();
                    if (this.byteCount_ == -1) {
                        throw new EOFException();
                    }
                    this.byteCount_ &= 0xFF;
                    if (this.byteCount_ == 0) break;
                }
                if (this.byteCount_ == 0) continue;
                int dummy = this.in_.read();
                --this.byteCount_;
            }
        }
    }
}

