/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

final class LZWDecompressionStringTable {
    private static final int NO_PREFIX = -1;
    private static final int DEFAULT_TABLE_SIZE = 4096;
    protected byte[][] strings_;
    protected int size_ = 0;
    protected int codeSize_;
    protected int tableSize_;

    public LZWDecompressionStringTable(int codesize) {
        this(codesize, 4096);
    }

    public LZWDecompressionStringTable(int codesize, int tablesize) {
        this.tableSize_ = tablesize;
        this.codeSize_ = codesize;
        this.initTable();
    }

    protected void initTable() {
        this.strings_ = new byte[this.tableSize_][];
        int codes = (1 << this.codeSize_) + 2;
        for (int idx = 0; idx < codes; ++idx) {
            this.addCharString(-1, (byte)idx);
        }
    }

    public void clearTable() {
        this.size_ = (1 << this.codeSize_) + 2;
    }

    public int addCharString(int index, byte value) {
        if (index == -1) {
            this.strings_[this.size_] = new byte[]{value};
        } else {
            int length = this.strings_[index].length + 1;
            byte[] expanded_value = new byte[length];
            System.arraycopy(this.strings_[index], 0, expanded_value, 0, length - 1);
            expanded_value[length - 1] = value;
            this.strings_[this.size_] = expanded_value;
        }
        return this.size_++;
    }

    public int expandCode(byte[] buf, int offset, int code, int skip_head) {
        int max_length = buf.length - offset;
        int string_length = this.strings_[code].length - skip_head;
        int length = max_length > string_length ? string_length : max_length;
        System.arraycopy(this.strings_[code], skip_head, buf, offset, length);
        return string_length > length ? -(length + skip_head) : length;
    }

    public final boolean contains(int code) {
        return code < this.size_;
    }
}

