/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import com.sun.jimi.core.util.lzw.BitInput;
import com.sun.jimi.core.util.lzw.LZWDecompressionStringTable;
import java.io.IOException;
import java.io.InputStream;

public final class LZWDecompressor {
    private int CLEAR_CODE;
    private int END_OF_INPUT;
    protected BitInput input_;
    protected int initialCodeSize_;
    protected int codeSize_;
    protected int limit_;
    protected boolean tiff_;
    protected LZWDecompressionStringTable table_;
    protected int count_;
    protected int oldCode_;
    protected byte oldCodeFirstChar_;
    protected int leftOverCode_;
    protected int leftOverIndex_;
    protected int leftOverOldCode_;
    protected boolean isLeftOver_;

    public LZWDecompressor(InputStream in, int codeSize, boolean TIFF) {
        this.initialCodeSize_ = codeSize;
        this.tiff_ = TIFF;
        this.CLEAR_CODE = 1 << codeSize;
        this.END_OF_INPUT = (1 << codeSize) + 1;
        this.table_ = new LZWDecompressionStringTable(codeSize);
        this.setInputStream(in);
        this.clearTable();
    }

    public void setInputStream(InputStream in) {
        this.input_ = new BitInput(in, !this.tiff_);
        this.clearTable();
        this.resetCodeSize();
    }

    public int decompress(byte[] buf) throws IOException {
        int code;
        int index = 0;
        int leftover_len = this.writeLeftOver(buf);
        if (this.isLeftOver_) {
            return buf.length;
        }
        index += leftover_len;
        while (index < buf.length && (code = this.getNextCode()) != this.END_OF_INPUT) {
            if (code == this.CLEAR_CODE) {
                this.clearTable();
                code = this.getNextCode();
                if (code == this.END_OF_INPUT) break;
                buf[index++] = (byte)code;
                this.oldCode_ = code;
                this.oldCodeFirstChar_ = (byte)code;
                continue;
            }
            if (this.table_.contains(code)) {
                int len = this.writeCode(buf, index, code);
                int code_index = this.table_.addCharString(this.oldCode_, buf[index]);
                if (code_index == this.limit_) {
                    this.incrementCodeSize();
                }
                this.oldCode_ = code;
                this.oldCodeFirstChar_ = buf[index];
                if (len < 0) {
                    return buf.length;
                }
                index += len;
                continue;
            }
            int code_index = this.table_.addCharString(this.oldCode_, this.oldCodeFirstChar_);
            int len = this.writeCode(buf, index, code_index);
            this.oldCode_ = code;
            this.oldCodeFirstChar_ = buf[index];
            if (code_index == this.limit_) {
                this.incrementCodeSize();
            }
            if (len < 0) {
                return buf.length;
            }
            index += len;
        }
        return index;
    }

    protected int writeCode(byte[] buf, int index, int code) {
        return this.writeCode(buf, index, code, 0);
    }

    protected int writeCode(byte[] buf, int index, int code, int skip) {
        int len = this.table_.expandCode(buf, index, code, skip);
        if (len < 0) {
            this.leftOverCode_ = code;
            this.leftOverOldCode_ = this.oldCode_;
            this.isLeftOver_ = true;
            this.leftOverIndex_ = -len;
        } else {
            this.isLeftOver_ = false;
        }
        return len;
    }

    protected int writeLeftOver(byte[] buf) {
        if (!this.isLeftOver_) {
            return 0;
        }
        int len = this.writeCode(buf, 0, this.leftOverCode_, this.leftOverIndex_);
        return len;
    }

    protected int getNextCode() throws IOException {
        int code = this.input_.read();
        return code;
    }

    protected void clearTable() {
        this.table_.clearTable();
        this.resetCodeSize();
    }

    protected void resetCodeSize() {
        this.count_ = 0;
        this.codeSize_ = this.initialCodeSize_;
        this.incrementCodeSize();
    }

    protected void incrementCodeSize() {
        if (this.codeSize_ != 12) {
            ++this.codeSize_;
            this.limit_ = (1 << this.codeSize_) - 1;
            if (this.tiff_) {
                --this.limit_;
            }
            this.input_.setNumBits(this.codeSize_);
        }
    }

    public void gifFinishBlocks() throws IOException {
        if (!this.tiff_) {
            this.input_.gifFinishBlocks();
        }
    }
}

