/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.PageFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntPageFrame
extends PageFrame {
    protected static final int BUFFER_VALUES = 5120;
    protected int[] pageData;
    protected static byte[] iobuffer = new byte[20480];

    public IntPageFrame(int size) {
        this.pageData = new int[size];
    }

    public void writeTo(OutputStream output) throws IOException {
        int pageIndex = 0;
        int totalLength = this.pageData.length;
        int bufferableValues = iobuffer.length;
        while (pageIndex < this.pageData.length) {
            int maxLength = totalLength - pageIndex;
            int buffered = bufferableValues > maxLength ? maxLength : bufferableValues;
            int bufferIndex = 0;
            while (bufferIndex < buffered) {
                int v = this.pageData[pageIndex++];
                IntPageFrame.iobuffer[bufferIndex++] = (byte)(v >>> 24);
                IntPageFrame.iobuffer[bufferIndex++] = (byte)(v >>> 16);
                IntPageFrame.iobuffer[bufferIndex++] = (byte)(v >>> 8);
                IntPageFrame.iobuffer[bufferIndex++] = (byte)v;
            }
            output.write(iobuffer, 0, bufferIndex);
        }
        output.flush();
    }

    public void readFrom(InputStream input) throws IOException {
        int pageIndex = 0;
        int totalLength = this.pageData.length;
        int bufferableValues = iobuffer.length;
        while (pageIndex < this.pageData.length) {
            int maxLength = (totalLength - pageIndex) * 4;
            int buffered = bufferableValues > maxLength ? maxLength : bufferableValues;
            input.read(iobuffer, 0, buffered);
            int bufferIndex = 0;
            while (bufferIndex < buffered) {
                this.pageData[pageIndex++] = iobuffer[bufferIndex++] << 24 & 0xFF000000 | iobuffer[bufferIndex++] << 16 & 0xFF0000 | iobuffer[bufferIndex++] << 8 & 0xFF00 | iobuffer[bufferIndex++] & 0xFF;
            }
        }
    }

    public int[] getPageData() {
        return this.pageData;
    }
}

